/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.util.crypt;

import java.io.UnsupportedEncodingException;
import java.security.GeneralSecurityException;
import org.apache.wicket.WicketRuntimeException;
import org.apache.wicket.util.crypt.Base64UrlSafe;
import org.apache.wicket.util.crypt.ICrypt;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractCrypt
implements ICrypt {
    private static final String DEFAULT_ENCRYPTION_KEY = "WiCkEt-CrYpT";
    private static final String CHARACTER_ENCODING = "UTF-8";
    private static final Logger log = LoggerFactory.getLogger((Class)AbstractCrypt.class);
    private String encryptionKey = "WiCkEt-CrYpT";

    public final String decryptUrlSafe(String text) {
        try {
            byte[] encrypted = Base64UrlSafe.decodeBase64(text.getBytes());
            return new String(this.decryptByteArray(encrypted), CHARACTER_ENCODING);
        }
        catch (UnsupportedEncodingException ex) {
            throw new WicketRuntimeException(ex.getMessage());
        }
    }

    public final String encryptUrlSafe(String plainText) {
        try {
            byte[] cipherText = this.encryptStringToByteArray(plainText);
            return new String(Base64UrlSafe.encodeBase64(cipherText));
        }
        catch (GeneralSecurityException e) {
            log.error("Unable to encrypt text '" + plainText + "'", (Throwable)e);
            return null;
        }
    }

    public String getKey() {
        return this.encryptionKey;
    }

    public void setKey(String key) {
        this.encryptionKey = key;
    }

    protected abstract byte[] crypt(byte[] var1, int var2) throws GeneralSecurityException;

    private final byte[] decryptByteArray(byte[] encrypted) {
        try {
            return this.crypt(encrypted, 2);
        }
        catch (GeneralSecurityException e) {
            throw new WicketRuntimeException("Unable to decrypt the text '" + encrypted.toString() + "'", e);
        }
    }

    private final byte[] encryptStringToByteArray(String plainText) throws GeneralSecurityException {
        try {
            return this.crypt(plainText.getBytes(CHARACTER_ENCODING), 1);
        }
        catch (UnsupportedEncodingException ex) {
            throw new WicketRuntimeException(ex.getMessage());
        }
    }
}

