/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.util.file;

import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.servlet.ServletContext;
import org.apache.wicket.util.file.File;
import org.apache.wicket.util.file.Folder;
import org.apache.wicket.util.file.IResourcePath;
import org.apache.wicket.util.resource.FileResourceStream;
import org.apache.wicket.util.resource.IResourceStream;
import org.apache.wicket.util.resource.UrlResourceStream;
import org.apache.wicket.util.string.StringList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class WebApplicationPath
implements IResourcePath {
    private static final Logger log = LoggerFactory.getLogger((Class)WebApplicationPath.class);
    private final List webappPaths = new ArrayList();
    private final List folders = new ArrayList();
    private final ServletContext servletContext;

    public WebApplicationPath(ServletContext servletContext) {
        this.servletContext = servletContext;
    }

    public void add(String path) {
        Folder folder = new Folder(path);
        if (folder.exists()) {
            this.folders.add(folder);
        } else {
            if (!path.startsWith("/")) {
                path = "/" + path;
            }
            if (!path.endsWith("/")) {
                path = path + "/";
            }
            this.webappPaths.add(path);
        }
    }

    public IResourceStream find(Class clazz, String pathname) {
        Iterator iter = this.folders.iterator();
        while (iter.hasNext()) {
            Folder folder = (Folder)iter.next();
            File file = new File(folder, pathname);
            if (!file.exists()) continue;
            return new FileResourceStream(file);
        }
        iter = this.webappPaths.iterator();
        while (iter.hasNext()) {
            String path = (String)iter.next();
            try {
                URL url = this.servletContext.getResource(path + pathname);
                if (url == null) continue;
                return new UrlResourceStream(url);
            }
            catch (Exception ex) {
            }
        }
        return null;
    }

    public String toString() {
        return "[folders = " + StringList.valueOf(this.folders) + ", webapppaths: " + StringList.valueOf(this.webappPaths) + "]";
    }
}

