/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.util.resource;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.wicket.WicketRuntimeException;
import org.apache.wicket.util.file.File;
import org.apache.wicket.util.resource.AbstractResourceStream;
import org.apache.wicket.util.resource.ResourceStreamNotFoundException;
import org.apache.wicket.util.time.Time;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZipResourceStream
extends AbstractResourceStream {
    private static final long serialVersionUID = 1L;
    private static final Logger log = LoggerFactory.getLogger((Class)ZipResourceStream.class);
    ByteArrayOutputStream bytearray = new ByteArrayOutputStream();

    public ZipResourceStream(File dir) {
        try {
            int BUFFER = 2048;
            BufferedInputStream origin = null;
            ZipOutputStream out = new ZipOutputStream(this.bytearray);
            byte[] data = new byte[BUFFER];
            String[] files = dir.list();
            if (files == null) {
                throw new IllegalArgumentException("Not a directory: " + dir);
            }
            for (int i = 0; i < files.length; ++i) {
                int count;
                log.debug("Adding: " + files[i]);
                FileInputStream fi = new FileInputStream(new File(dir, files[i]));
                origin = new BufferedInputStream(fi, BUFFER);
                ZipEntry entry = new ZipEntry(files[i]);
                out.putNextEntry(entry);
                while ((count = origin.read(data, 0, BUFFER)) != -1) {
                    out.write(data, 0, count);
                }
                origin.close();
            }
            out.close();
        }
        catch (Exception e) {
            throw new WicketRuntimeException(e);
        }
    }

    public void close() throws IOException {
    }

    public String getContentType() {
        return null;
    }

    public InputStream getInputStream() throws ResourceStreamNotFoundException {
        return new ByteArrayInputStream(this.bytearray.toByteArray());
    }

    public long length() {
        return this.bytearray.size();
    }

    public Time lastModifiedTime() {
        return null;
    }
}

