/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wss4j.dom.message;

import java.util.List;
import javax.crypto.SecretKey;
import org.apache.wss4j.common.WSEncryptionPart;
import org.apache.wss4j.common.derivedKey.ConversationConstants;
import org.apache.wss4j.common.ext.WSSecurityException;
import org.apache.wss4j.common.token.Reference;
import org.apache.wss4j.common.token.SecurityTokenReference;
import org.apache.wss4j.common.util.KeyUtils;
import org.apache.wss4j.dom.message.WSSecDerivedKeyBase;
import org.apache.wss4j.dom.message.WSSecEncrypt;
import org.apache.wss4j.dom.message.WSSecHeader;
import org.apache.wss4j.dom.util.WSSecurityUtil;
import org.apache.xml.security.keys.KeyInfo;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class WSSecDKEncrypt
extends WSSecDerivedKeyBase {
    private String symEncAlgo = "http://www.w3.org/2001/04/xmlenc#aes128-cbc";
    private int derivedKeyLength = -1;

    public Document build(Document doc, WSSecHeader secHeader) throws WSSecurityException {
        this.prepare(doc);
        this.prependDKElementToHeader(secHeader);
        Element externRefList = this.encrypt();
        this.addExternalRefElement(externRefList, secHeader);
        return doc;
    }

    public Element encrypt() throws WSSecurityException {
        if (this.getParts().isEmpty()) {
            this.getParts().add(WSSecurityUtil.getDefaultEncryptionPart(this.document));
        }
        return this.encryptForExternalRef(null, this.getParts());
    }

    public Element encryptForExternalRef(Element dataRef, List<WSEncryptionPart> references) throws WSSecurityException {
        KeyInfo keyInfo = this.createKeyInfo();
        SecretKey key = this.getDerivedKey(this.symEncAlgo);
        List<String> encDataRefs = WSSecEncrypt.doEncryption(this.document, this.getIdAllocator(), keyInfo, key, this.symEncAlgo, references, this.callbackLookup);
        if (dataRef == null) {
            dataRef = this.document.createElementNS("http://www.w3.org/2001/04/xmlenc#", "xenc:ReferenceList");
        }
        return WSSecEncrypt.createDataRefList(this.document, dataRef, encDataRefs);
    }

    private KeyInfo createKeyInfo() throws WSSecurityException {
        KeyInfo keyInfo = new KeyInfo(this.document);
        SecurityTokenReference secToken = new SecurityTokenReference(this.document);
        secToken.addWSSENamespace();
        Reference ref = new Reference(this.document);
        ref.setURI("#" + this.getId());
        String ns = ConversationConstants.getWSCNs((int)this.getWscVersion()) + "/dk";
        ref.setValueType(ns);
        secToken.setReference(ref);
        keyInfo.addUnknownElement(secToken.getElement());
        Element keyInfoElement = keyInfo.getElement();
        keyInfoElement.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:ds", "http://www.w3.org/2000/09/xmldsig#");
        return keyInfo;
    }

    public void addExternalRefElement(Element referenceList, WSSecHeader secHeader) {
        Node node = this.getdktElement().getNextSibling();
        if (node != null && 1 == node.getNodeType()) {
            secHeader.getSecurityHeader().insertBefore(referenceList, node);
        } else {
            secHeader.getSecurityHeader().appendChild(referenceList);
        }
    }

    public void setSymmetricEncAlgorithm(String algo) {
        this.symEncAlgo = algo;
    }

    @Override
    protected int getDerivedKeyLength() throws WSSecurityException {
        return this.derivedKeyLength > 0 ? this.derivedKeyLength : KeyUtils.getKeyLength((String)this.symEncAlgo);
    }

    public void setDerivedKeyLength(int keyLength) {
        this.derivedKeyLength = keyLength;
    }
}

