/*
 * Decompiled with CFR 0.152.
 */
package net.sf.log4jdbc.log;

import net.sf.log4jdbc.Properties;
import net.sf.log4jdbc.log.SpyLogDelegator;
import net.sf.log4jdbc.log.log4j2.Log4j2SpyLogDelegator;

public class SpyLogFactory {
    private static SpyLogDelegator logger;

    private SpyLogFactory() {
    }

    public static SpyLogDelegator getSpyLogDelegator() {
        if (logger == null) {
            SpyLogFactory.loadSpyLogDelegator(Properties.getSpyLogDelegatorName());
        }
        return logger;
    }

    public static void loadSpyLogDelegator(String spyLogDelegatorName) {
        if (spyLogDelegatorName == null) {
            try {
                SpyLogFactory.setSpyLogDelegator(new Log4j2SpyLogDelegator());
            }
            catch (NoClassDefFoundError e) {
                throw new NoClassDefFoundError("Unable to find Log4j2 as default logging library. Please provide a logging library and configure a valid spyLogDelegator name in the properties file.");
            }
        }
        try {
            Object loadedClass = Class.forName(spyLogDelegatorName).newInstance();
            if (loadedClass == null) {
                throw new IllegalArgumentException("spyLogDelegatorName loads a null SpyLogDelegator");
            }
            SpyLogFactory.setSpyLogDelegator((SpyLogDelegator)loadedClass);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("spyLogDelegatorName does not allow to load a valid SpyLogDelegator: " + e.getMessage());
        }
        catch (NoClassDefFoundError e) {
            throw new NoClassDefFoundError("Cannot find a library corresponding to the property log4jdbc.spylogdelegator.name. Please provide a logging library and configure a valid spyLogDelegator name in the properties file.");
        }
    }

    public static void setSpyLogDelegator(SpyLogDelegator logDelegator) {
        if (logDelegator == null) {
            throw new IllegalArgumentException("log4jdbc: logDelegator cannot be null.");
        }
        logger = logDelegator;
    }
}

