/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.container.property;

import java.util.Arrays;
import java.util.Map;
import java.util.Properties;
import org.codehaus.cargo.container.configuration.entry.DataSource;
import org.codehaus.cargo.container.configuration.entry.Resource;
import org.codehaus.cargo.container.internal.util.PropertyUtils;
import org.codehaus.cargo.container.property.TransactionSupport;

public class DataSourceConverter {
    public DataSource fromPropertyString(String datasourceInformation) {
        return this.fromProperties(PropertyUtils.splitPropertiesOnPipe(PropertyUtils.escapeBackSlashesIfNotNull(datasourceInformation)));
    }

    public DataSource fromProperties(Properties properties) {
        DataSource data = new DataSource();
        data.setJndiLocation(properties.getProperty("cargo.datasource.jndi"));
        String connectionType = properties.getProperty("cargo.datasource.type");
        if ("javax.sql.XADataSource".equals(connectionType)) {
            data.setConnectionType(connectionType);
        } else {
            data.setConnectionType("java.sql.Driver");
        }
        String transactionSupportProperty = properties.getProperty("cargo.datasource.transactionsupport");
        if (TransactionSupport.XA_TRANSACTION.toString().equals(transactionSupportProperty) || "javax.sql.XADataSource".equals(connectionType)) {
            data.setTransactionSupport(TransactionSupport.XA_TRANSACTION);
        } else if (TransactionSupport.LOCAL_TRANSACTION.toString().equals(transactionSupportProperty)) {
            data.setTransactionSupport(TransactionSupport.LOCAL_TRANSACTION);
        } else {
            data.setTransactionSupport(TransactionSupport.NO_TRANSACTION);
        }
        data.setDriverClass(properties.getProperty("cargo.datasource.driver"));
        data.setUrl(properties.getProperty("cargo.datasource.url"));
        data.setUsername(properties.getProperty("cargo.datasource.username"));
        data.setPassword(properties.getProperty("cargo.datasource.password"));
        data.setId(properties.getProperty("cargo.datasource.id"));
        String driverPropertiesAsASemicolonDelimitedString = properties.getProperty("cargo.datasource.properties");
        data.setConnectionProperties(this.getDriverPropertiesFromString(driverPropertiesAsASemicolonDelimitedString));
        if (data.getId() == null) {
            data.setId(DataSourceConverter.createIdFromJndiLocationIfNotNull(data.getJndiLocation()));
        }
        this.setCredentialsIfInsideDriverProperties(data);
        return data;
    }

    private void setCredentialsIfInsideDriverProperties(DataSource data) {
        if (data.getConnectionProperties() != null) {
            if (data.getConnectionProperties().containsKey("user")) {
                data.setUsername(data.getConnectionProperties().getProperty("user"));
            }
            if (data.getConnectionProperties().containsKey("password")) {
                data.setPassword(data.getConnectionProperties().getProperty("password"));
            }
        }
    }

    private Properties getDriverPropertiesFromString(String property) {
        if (property != null && !property.trim().equals("")) {
            return PropertyUtils.splitPropertiesOnSemicolon(property);
        }
        return new Properties();
    }

    private static String createIdFromJndiLocationIfNotNull(String jndiLocation) {
        String id = null;
        if (jndiLocation != null) {
            id = DataSourceConverter.createIdFromJndiLocation(jndiLocation);
        }
        return id;
    }

    protected static String createIdFromJndiLocation(String jndiLocation) {
        int[] delimeters = new int[]{jndiLocation.lastIndexOf(47), jndiLocation.lastIndexOf(46), jndiLocation.lastIndexOf(58)};
        Arrays.sort(delimeters);
        int highestIndex = delimeters[2];
        return jndiLocation.substring(highestIndex + 1);
    }

    public String toPropertyString(DataSource data) {
        Properties properties = this.toProperties(data);
        return PropertyUtils.joinOnPipe(PropertyUtils.toMap(properties));
    }

    public Properties toProperties(DataSource data) {
        Properties properties = new Properties();
        PropertyUtils.setPropertyIfNotNull(properties, "cargo.datasource.jndi", data.getJndiLocation());
        PropertyUtils.setPropertyIfNotNull(properties, "cargo.datasource.type", data.getConnectionType());
        PropertyUtils.setPropertyIfNotNull(properties, "cargo.datasource.transactionsupport", data.getTransactionSupport());
        PropertyUtils.setPropertyIfNotNull(properties, "cargo.datasource.driver", data.getDriverClass());
        PropertyUtils.setPropertyIfNotNull(properties, "cargo.datasource.url", data.getUrl());
        PropertyUtils.setPropertyIfNotNull(properties, "cargo.datasource.username", data.getUsername());
        PropertyUtils.setPropertyIfNotNull(properties, "cargo.datasource.password", data.getPassword());
        PropertyUtils.setPropertyIfNotNull(properties, "cargo.datasource.id", data.getId());
        PropertyUtils.setPropertyIfNotNull(properties, "cargo.datasource.properties", this.getConnectionPropertiesAsASemicolonDelimitedString(data));
        return properties;
    }

    public String getConnectionPropertiesAsASemicolonDelimitedString(DataSource data) {
        if (data.getConnectionProperties() != null && data.getConnectionProperties().size() != 0) {
            return PropertyUtils.joinOnSemicolon(PropertyUtils.toMap(data.getConnectionProperties()));
        }
        return null;
    }

    public Resource convertToResource(DataSource ds, String resourceType, String driverParameter) {
        Properties parameters = new Properties();
        if (ds.getUrl() != null) {
            PropertyUtils.setPropertyIfNotNull(parameters, "url", ds.getUrl());
        }
        PropertyUtils.setPropertyIfNotNull(parameters, "user", ds.getUsername());
        PropertyUtils.setPropertyIfNotNull(parameters, "password", ds.getPassword());
        PropertyUtils.setPropertyIfNotNull(parameters, driverParameter, ds.getDriverClass());
        parameters.putAll((Map<?, ?>)ds.getConnectionProperties());
        Resource resource = new Resource(ds.getJndiLocation(), resourceType);
        resource.setParameters(PropertyUtils.toMap(parameters));
        return resource;
    }
}

