/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.container.spi;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import org.codehaus.cargo.container.ContainerException;
import org.codehaus.cargo.container.LocalContainer;
import org.codehaus.cargo.container.State;
import org.codehaus.cargo.container.configuration.LocalConfiguration;
import org.codehaus.cargo.container.deployer.URLDeployableMonitor;
import org.codehaus.cargo.container.spi.AbstractContainer;
import org.codehaus.cargo.container.spi.deployer.DeployerWatchdog;
import org.codehaus.cargo.container.spi.util.ContainerUtils;
import org.codehaus.cargo.util.DefaultFileHandler;
import org.codehaus.cargo.util.FileHandler;

public abstract class AbstractLocalContainer
extends AbstractContainer
implements LocalContainer {
    private String output;
    private boolean append = false;
    private long timeout = 120000L;
    private LocalConfiguration configuration;
    private State state = State.UNKNOWN;
    private FileHandler fileHandler;

    public AbstractLocalContainer(LocalConfiguration configuration) {
        this.configuration = configuration;
        this.fileHandler = new DefaultFileHandler();
    }

    public final void setOutput(String output) {
        this.output = output;
    }

    public final void setAppend(boolean isAppend) {
        this.append = isAppend;
    }

    public final String getOutput() {
        return this.output;
    }

    public final boolean isAppend() {
        return this.append;
    }

    protected void verify() {
    }

    protected abstract void startInternal() throws Exception;

    protected abstract void stopInternal() throws Exception;

    public final void start() {
        this.verify();
        this.getConfiguration().configure(this);
        this.getLogger().info(this.getName() + " starting...", this.getClass().getName());
        this.setState(State.STARTING);
        try {
            this.startInternal();
            if (this.getTimeout() != 0L) {
                this.waitForCompletion(true);
            }
        }
        catch (Exception e) {
            this.setState(State.UNKNOWN);
            throw new ContainerException("Failed to start the " + this.getName() + " container." + (this.getOutput() == null ? "" : " Check the [" + this.getOutput() + "] file " + "containing the container logs for more details."), e);
        }
        this.setState(State.STARTED);
        this.getLogger().info(this.getName() + " started on port [" + this.getConfiguration().getPropertyValue("cargo.servlet.port") + "]", this.getClass().getName());
    }

    public final void stop() {
        this.verify();
        this.getLogger().info(this.getName() + " is stopping...", this.getClass().getName());
        this.setState(State.STOPPING);
        boolean isAppend = this.isAppend();
        try {
            this.setAppend(true);
            this.stopInternal();
            if (this.getTimeout() != 0L) {
                this.waitForCompletion(false);
            }
        }
        catch (Exception e) {
            this.setState(State.UNKNOWN);
            throw new ContainerException("Failed to stop the " + this.getName() + " container." + (this.getOutput() == null ? "" : " Check the [" + this.getOutput() + "] file " + "containing the container logs for more details."), e);
        }
        finally {
            this.setAppend(isAppend);
        }
        this.setState(State.STOPPED);
        this.getLogger().info(this.getName() + " is stopped", this.getClass().getName());
    }

    protected void waitForCompletion(boolean waitForStarting) throws InterruptedException {
        LocalConfiguration config = this.getConfiguration();
        if (waitForStarting) {
            URLDeployableMonitor monitor = new URLDeployableMonitor(ContainerUtils.getCPCURL(config), this.getTimeout(), "Cargo Ping Component used to verify if the container is started.");
            monitor.setLogger(this.getLogger());
            DeployerWatchdog watchdog = new DeployerWatchdog(monitor);
            watchdog.setLogger(this.getLogger());
            watchdog.watch(waitForStarting);
        } else {
            this.waitForPortShutdown(config.getPropertyValue("cargo.servlet.port"), config.getPropertyValue("cargo.rmi.port"));
            Thread.sleep(5000L);
        }
    }

    protected void waitForPortShutdown(String ... ports) throws InterruptedException {
        long deadline = System.currentTimeMillis() + this.getTimeout();
        int connectTimeout = 0;
        for (String p : ports) {
            int port;
            if (p == null) continue;
            try {
                port = Integer.parseInt(p);
            }
            catch (NumberFormatException e) {
                continue;
            }
            if (port < 1 || port > 65535) continue;
            try {
                this.waitForPortShutdown(port, connectTimeout, deadline);
            }
            catch (IOException e) {
                connectTimeout = 250;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitForPortShutdown(int port, int connectTimeout, long deadline) throws IOException, InterruptedException {
        this.getLogger().debug("Waiting for port " + port + " to shutdown, deadline " + deadline, this.getClass().getName());
        while (true) {
            Object v1;
            Object var11_11;
            Socket s;
            block14: {
                Throwable throwable3;
                IOException e42;
                Object var8_8;
                s = new Socket();
                try {
                    this.getLogger().debug("\tConnection attempt with socket " + s, this.getClass().getName());
                    s.bind(null);
                    s.connect(new InetSocketAddress("localhost", port), connectTimeout);
                    this.getLogger().debug("\tSocket " + s + " for port " + port + " managed to connect", this.getClass().getName());
                    try {
                        s.shutdownOutput();
                    }
                    catch (IOException e2) {
                        this.getLogger().debug("\tFailed to shutdown output for socket " + s + ": " + e2, this.getClass().getName());
                    }
                    try {
                        s.shutdownInput();
                    }
                    catch (IOException e3) {
                        this.getLogger().debug("\tFailed to shutdown input for socket " + s + ": " + e3, this.getClass().getName());
                    }
                    this.getLogger().debug("\tSocket " + s + " for port " + port + " shutdown", this.getClass().getName());
                    var8_8 = null;
                }
                catch (Throwable throwable2) {
                    Object v0;
                    var8_8 = null;
                    try {
                        try {
                            s.close();
                            v0 = null;
                        }
                        catch (IOException e42) {
                            this.getLogger().debug("\tFailed to close socket " + s + ": " + e42, this.getClass().getName());
                            v0 = null;
                        }
                    }
                    catch (Throwable throwable3) {
                        v0 = null;
                    }
                    var11_11 = v0;
                    this.getLogger().debug("\tSocket " + s + " for port " + port + " closed", this.getClass().getName());
                    s = null;
                    System.gc();
                    throw throwable2;
                }
                try {
                    try {
                        s.close();
                        v1 = null;
                    }
                    catch (IOException e42) {
                        this.getLogger().debug("\tFailed to close socket " + s + ": " + e42, this.getClass().getName());
                        v1 = null;
                    }
                    break block14;
                }
                catch (Throwable throwable3) {
                    v1 = null;
                }
                {
                }
            }
            var11_11 = v1;
            this.getLogger().debug("\tSocket " + s + " for port " + port + " closed", this.getClass().getName());
            s = null;
            System.gc();
            if (System.currentTimeMillis() > deadline) {
                throw new ContainerException("Server port " + port + " did not shutdown within the timeout period [" + this.getTimeout() + "]");
            }
            Thread.sleep(1000L);
        }
    }

    public void setConfiguration(LocalConfiguration configuration) {
        this.configuration = configuration;
    }

    public LocalConfiguration getConfiguration() {
        return this.configuration;
    }

    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }

    public long getTimeout() {
        return this.timeout;
    }

    public State getState() {
        return this.state;
    }

    protected void setState(State state) {
        this.state = state;
    }

    public FileHandler getFileHandler() {
        return this.fileHandler;
    }

    public void setFileHandler(FileHandler fileHandler) {
        this.fileHandler = fileHandler;
    }
}

