/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.container.spi.configuration;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.tools.ant.types.FilterChain;
import org.codehaus.cargo.container.ContainerException;
import org.codehaus.cargo.container.LocalContainer;
import org.codehaus.cargo.container.configuration.ConfigurationType;
import org.codehaus.cargo.container.configuration.FileConfig;
import org.codehaus.cargo.container.configuration.StandaloneLocalConfiguration;
import org.codehaus.cargo.container.property.LoggingLevel;
import org.codehaus.cargo.container.spi.configuration.AbstractLocalConfiguration;
import org.codehaus.cargo.util.CargoException;
import org.codehaus.cargo.util.FileHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractStandaloneLocalConfiguration
extends AbstractLocalConfiguration
implements StandaloneLocalConfiguration {
    private List<FileConfig> files;
    private FilterChain filterChain;
    private Map<String, Map<FileHandler.XmlReplacement, String>> xmlReplacements;

    public AbstractStandaloneLocalConfiguration(String dir) {
        super(dir);
        this.setProperty("cargo.logging", LoggingLevel.MEDIUM.getLevel());
        this.files = new ArrayList<FileConfig>();
        this.xmlReplacements = new HashMap<String, Map<FileHandler.XmlReplacement, String>>();
    }

    @Override
    public void configure(LocalContainer container) {
        super.configure(container);
        this.configureFiles(this.getFilterChain());
        this.performXmlReplacements(container);
    }

    protected void performXmlReplacements(LocalContainer container) {
        for (Map.Entry<String, Map<FileHandler.XmlReplacement, String>> xmlReplacements : this.xmlReplacements.entrySet()) {
            HashMap<FileHandler.XmlReplacement, String> replacements = new HashMap<FileHandler.XmlReplacement, String>();
            for (Map.Entry<FileHandler.XmlReplacement, String> xmlReplacement : xmlReplacements.getValue().entrySet()) {
                String value = container.getConfiguration().getPropertyValue(xmlReplacement.getValue());
                if (value != null) {
                    replacements.put(xmlReplacement.getKey(), value);
                    continue;
                }
                replacements.put(xmlReplacement.getKey(), xmlReplacement.getValue());
            }
            if (replacements.isEmpty()) continue;
            String destinationFile = this.getFileHandler().append(container.getConfiguration().getHome(), xmlReplacements.getKey());
            this.getFileHandler().replaceInXmlFile(destinationFile, replacements);
        }
    }

    protected void setupConfigurationDir() throws IOException {
        String timestampFile = this.getFileHandler().append(this.getHome(), ".cargo");
        if (!(this.getFileHandler().exists(timestampFile) || this.getFileHandler().exists(this.getHome()) && this.getFileHandler().isDirectoryEmpty(this.getHome()) || !this.getFileHandler().exists(this.getHome()))) {
            throw new ContainerException("Invalid configuration dir [" + this.getHome() + "]. " + "When using standalone configurations, the configuration dir must point to an " + "empty directory. Note that everything in that dir will get deleted by Cargo.");
        }
        this.getFileHandler().delete(this.getHome());
        this.getFileHandler().mkdirs(this.getHome());
        this.getFileHandler().createFile(timestampFile);
    }

    protected final FilterChain createFilterChain() {
        this.filterChain = new FilterChain();
        this.getAntUtils().addTokensToFilterChain(this.filterChain, this.getProperties());
        return this.filterChain;
    }

    protected void addXmlReplacement(String filename, String xpathExpression, String configurationPropertyName) {
        this.addXmlReplacement(filename, xpathExpression, null, configurationPropertyName);
    }

    protected void addXmlReplacement(String filename, String xpathExpression, String attributeName, String configurationPropertyName) {
        Map<FileHandler.XmlReplacement, String> fileReplacements = this.xmlReplacements.get(filename);
        if (fileReplacements == null) {
            fileReplacements = new HashMap<FileHandler.XmlReplacement, String>();
            this.xmlReplacements.put(filename, fileReplacements);
        }
        fileReplacements.put(new FileHandler.XmlReplacement(xpathExpression, attributeName), configurationPropertyName);
    }

    protected void removeXmlReplacement(String filename, String xpathExpression) {
        this.removeXmlReplacement(filename, xpathExpression, null);
    }

    protected void removeXmlReplacement(String filename, String xpathExpression, String attributeName) {
        Map<FileHandler.XmlReplacement, String> fileReplacements = this.xmlReplacements.get(filename);
        if (fileReplacements != null) {
            fileReplacements.remove(new FileHandler.XmlReplacement(xpathExpression, attributeName));
            if (fileReplacements.isEmpty()) {
                this.xmlReplacements.remove(filename);
            }
        }
    }

    @Override
    public void verify() {
        super.verify();
        this.verifyLogging();
    }

    private void verifyLogging() {
        String level = this.getPropertyValue("cargo.logging");
        try {
            LoggingLevel.toLevel(level);
        }
        catch (IllegalArgumentException e) {
            throw new ContainerException("Invalid logging level [" + level + "]. Valid levels are {\"low\", \"medium\", " + "\"high\"}");
        }
    }

    @Override
    public ConfigurationType getType() {
        return ConfigurationType.STANDALONE;
    }

    @Override
    public FilterChain getFilterChain() {
        if (this.filterChain == null) {
            this.filterChain = this.createFilterChain();
        }
        return this.filterChain;
    }

    @Override
    public void setFileProperty(FileConfig fileConfig) {
        this.files.add(fileConfig);
    }

    @Override
    public void setConfigFileProperty(FileConfig fileConfig) {
        fileConfig.setOverwrite(true);
        fileConfig.setConfigfile(true);
        this.setFileProperty(fileConfig);
    }

    @Override
    public List<FileConfig> getFileProperties() {
        return this.files;
    }

    protected void configureFiles(FilterChain filterChain) {
        List<FileConfig> files = this.files;
        for (FileConfig fileConfig : files) {
            boolean isDirectory = false;
            if (fileConfig.getFile() == null) {
                throw new RuntimeException("File cannot be null");
            }
            File origFile = new File(fileConfig.getFile());
            if (origFile.isDirectory()) {
                isDirectory = true;
            }
            String destFile = this.getDestFileLocation(fileConfig.getFile(), fileConfig.getToDir(), fileConfig.getToFile());
            if (origFile.exists() && !fileConfig.getOverwrite()) continue;
            if (isDirectory) {
                String destDir = this.getDestDirectoryLocation(fileConfig.getFile(), fileConfig.getToDir());
                if (fileConfig.getConfigfile()) {
                    this.getFileHandler().copyDirectory(fileConfig.getFile(), destDir, filterChain, fileConfig.getEncoding());
                    continue;
                }
                this.getFileHandler().copyDirectory(fileConfig.getFile(), destDir);
                continue;
            }
            if (fileConfig.getConfigfile()) {
                this.getFileHandler().copyFile(fileConfig.getFile(), destFile, filterChain, fileConfig.getEncoding());
                continue;
            }
            this.getFileHandler().copyFile(fileConfig.getFile(), destFile, fileConfig.getOverwrite());
        }
    }

    protected String getDestFileLocation(String file, String toDir, String toFile) {
        String filename;
        String fileName = file;
        String finalFile = null;
        if (fileName == null) {
            throw new RuntimeException("file cannot be null");
        }
        if (toFile == null && toDir != null) {
            filename = new File(fileName).getName();
            finalFile = this.getHome() + "/" + toDir + "/" + filename;
        } else if (toFile != null && toDir == null) {
            finalFile = this.getHome() + "/" + toFile;
        } else if (toFile == null && toDir == null) {
            filename = new File(fileName).getName();
            finalFile = this.getHome() + "/" + filename;
        } else if (toFile != null && toDir != null) {
            finalFile = this.getHome() + "/" + toDir + "/" + toFile;
        }
        while (finalFile.contains("//")) {
            finalFile = finalFile.replaceAll("//", "/");
        }
        return finalFile;
    }

    protected String getDestDirectoryLocation(String file, String toDir) {
        String fileName = file;
        String finalDir = null;
        if (fileName == null) {
            throw new RuntimeException("file cannot be null");
        }
        if (toDir != null) {
            finalDir = this.getHome() + "/" + toDir;
        } else if (toDir == null) {
            finalDir = this.getHome();
        }
        while (finalDir.contains("//")) {
            finalDir = finalDir.replaceAll("//", "/");
        }
        return finalDir;
    }

    protected void replaceInFile(String file, Map<String, String> replacements, String encoding) throws CargoException {
        if (replacements.isEmpty()) {
            return;
        }
        String path = this.getHome() + "/" + file;
        this.getFileHandler().replaceInFile(path, replacements, encoding);
    }
}

