/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.maven.runtime.support.stubgen.render;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.Writer;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.codehaus.groovy.maven.runtime.support.stubgen.UnsupportedFeatureException;
import org.codehaus.groovy.maven.runtime.support.stubgen.model.ClassDef;
import org.codehaus.groovy.maven.runtime.support.stubgen.model.ConstructorDef;
import org.codehaus.groovy.maven.runtime.support.stubgen.model.FieldDef;
import org.codehaus.groovy.maven.runtime.support.stubgen.model.ImportDef;
import org.codehaus.groovy.maven.runtime.support.stubgen.model.JavaDocAware;
import org.codehaus.groovy.maven.runtime.support.stubgen.model.JavaDocDef;
import org.codehaus.groovy.maven.runtime.support.stubgen.model.MethodDef;
import org.codehaus.groovy.maven.runtime.support.stubgen.model.ModifiersAware;
import org.codehaus.groovy.maven.runtime.support.stubgen.model.ModifiersDef;
import org.codehaus.groovy.maven.runtime.support.stubgen.model.PackageDef;
import org.codehaus.groovy.maven.runtime.support.stubgen.model.ParameterDef;
import org.codehaus.groovy.maven.runtime.support.stubgen.model.SuperParameterDef;
import org.codehaus.groovy.maven.runtime.support.stubgen.model.TagDef;
import org.codehaus.groovy.maven.runtime.support.stubgen.model.TypeDef;
import org.codehaus.groovy.maven.runtime.support.stubgen.render.Renderer;

public class RendererSupport
implements Renderer {
    protected final ClassDef clazz;
    protected final Map importAliases = new HashMap();
    protected final Map definedMethods = new HashMap();
    static final /* synthetic */ boolean $assertionsDisabled;

    protected RendererSupport(ClassDef clazz) {
        if (!$assertionsDisabled && clazz == null) {
            throw new AssertionError();
        }
        this.clazz = clazz;
        if (!$assertionsDisabled && clazz.getParent() == null) {
            throw new AssertionError();
        }
        Iterator iter = clazz.getMethods().iterator();
        while (iter.hasNext()) {
            MethodDef method = (MethodDef)iter.next();
            this.definedMethods.put(method.signature(), method);
        }
    }

    public void render(Writer writer) throws IOException {
        if (!$assertionsDisabled && writer == null) {
            throw new AssertionError();
        }
        PrintWriter out = new PrintWriter(writer);
        this.renderHeader(out);
        this.renderPackage(out);
        this.renderImports(out);
        this.renderClass(out);
        out.flush();
    }

    public String getName() {
        return this.clazz.getName();
    }

    public String getPackage() {
        PackageDef pkg = this.clazz.getPackage();
        if (pkg != null) {
            return pkg.getName();
        }
        return null;
    }

    protected void renderHeader(PrintWriter out) {
        if (!$assertionsDisabled && out == null) {
            throw new AssertionError();
        }
        out.println("//");
        out.println("// Generated stub from " + this.clazz.getParent().getUrl());
        out.println("//");
        out.println();
    }

    protected void renderPackage(PrintWriter out) {
        if (!$assertionsDisabled && out == null) {
            throw new AssertionError();
        }
        PackageDef def = this.clazz.getPackage();
        if (def != null) {
            out.print("package ");
            out.print(def.getName());
            out.println(";");
        } else {
            out.println("// Default package");
        }
        out.println();
    }

    protected void renderImports(PrintWriter out) {
        if (!$assertionsDisabled && out == null) {
            throw new AssertionError();
        }
        Set imports = this.clazz.getImports();
        if (!$assertionsDisabled && imports == null) {
            throw new AssertionError();
        }
        if (!imports.isEmpty()) {
            Iterator iter = imports.iterator();
            while (iter.hasNext()) {
                ImportDef def = (ImportDef)iter.next();
                this.renderImport(out, def);
            }
            out.println();
        }
    }

    protected void renderImport(PrintWriter out, ImportDef def) {
        if (!$assertionsDisabled && out == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && def == null) {
            throw new AssertionError();
        }
        String alias = def.getAlias();
        if (alias != null) {
            this.importAliases.put(alias, def);
            out.print("// Import alias '");
            out.print(alias);
            out.print("' will resolve to the full-qualified name: ");
            out.println(def.getQualifiedName());
            return;
        }
        out.print("import ");
        if (def.isStatic()) {
            out.print("static ");
        }
        out.print(def.getQualifiedName());
        if (def.isWildcard()) {
            out.print(".*");
        }
        out.println(";");
    }

    protected void renderType(PrintWriter out, TypeDef def) {
        if (!$assertionsDisabled && out == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && def == null) {
            throw new AssertionError();
        }
        String name = def.getName();
        if (name == null) {
            name = "java.lang.Object";
        } else {
            ImportDef alias = (ImportDef)this.importAliases.get(name);
            if (alias != null) {
                name = alias.getQualifiedName();
            }
        }
        out.print(name);
        int dimensions = def.getDimensions();
        for (int i = 0; i < dimensions; ++i) {
            out.print("[]");
        }
    }

    protected void renderTypeSet(PrintWriter out, Set types) {
        if (!$assertionsDisabled && out == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && types == null) {
            throw new AssertionError();
        }
        Iterator iter = types.iterator();
        while (iter.hasNext()) {
            TypeDef def = (TypeDef)iter.next();
            this.renderType(out, def);
            if (!iter.hasNext()) continue;
            out.print(", ");
        }
    }

    protected void renderModifiers(PrintWriter out, ModifiersAware source) {
        if (!$assertionsDisabled && out == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && source == null) {
            throw new AssertionError();
        }
        ModifiersDef modifiers = source.getModifiers();
        if (!$assertionsDisabled && modifiers == null) {
            throw new AssertionError();
        }
        Set values = modifiers.getValues();
        if (!values.isEmpty()) {
            Iterator iter = values.iterator();
            while (iter.hasNext()) {
                String modifier = (String)iter.next();
                out.print(modifier);
                if (!iter.hasNext()) continue;
                out.print(" ");
            }
            out.print(" ");
        }
    }

    protected void renderJavaDoc(PrintWriter out, JavaDocAware source, String indent) {
        if (!$assertionsDisabled && out == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && source == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && indent == null) {
            throw new AssertionError();
        }
        JavaDocDef def = source.getJavaDoc();
        if (def != null) {
            out.print(indent);
            out.println("/**");
            String comment = def.getComment();
            if (comment != null && (comment = comment.trim()).length() > 0) {
                BufferedReader reader = new BufferedReader(new StringReader(comment));
                try {
                    String line;
                    while ((line = reader.readLine()) != null) {
                        out.print(indent);
                        out.print(" * ");
                        out.println(line);
                    }
                }
                catch (IOException e) {
                    throw new InternalError("Failed to process JavaDoc comment string: " + comment);
                }
            }
            Set tags = def.getTags();
            if (!$assertionsDisabled && tags == null) {
                throw new AssertionError();
            }
            if (!tags.isEmpty()) {
                if (comment != null && comment.length() > 0) {
                    out.print(indent);
                    out.println(" *");
                }
                Iterator iter = tags.iterator();
                while (iter.hasNext()) {
                    TagDef tag = (TagDef)iter.next();
                    out.print(indent);
                    out.print(" * @");
                    out.print(tag.getName());
                    String value = tag.getValue();
                    if (value != null && value.length() > 0) {
                        out.print(" ");
                        out.print(value);
                    }
                    out.println();
                }
            }
            out.print(indent);
            out.println(" */");
        }
    }

    protected void renderClass(PrintWriter out) {
        if (!$assertionsDisabled && out == null) {
            throw new AssertionError();
        }
        this.renderJavaDoc(out, this.clazz, "");
        ModifiersDef modifiers = this.clazz.getModifiers();
        if (!modifiers.hasAccessModifiers()) {
            modifiers.add("public");
        }
        this.renderModifiers(out, this.clazz);
        ClassDef.Type type = this.clazz.getType();
        if (!$assertionsDisabled && type == null) {
            throw new AssertionError();
        }
        out.print(type);
        out.print(" ");
        out.println(this.clazz.getName());
        switch (type.code) {
            case 0: {
                TypeDef superClass = this.clazz.getSuperClass();
                if (superClass != null) {
                    out.print("    extends ");
                    this.renderType(out, superClass);
                    out.println();
                }
                Set implementz = this.clazz.getImplements();
                if (!$assertionsDisabled && implementz == null) {
                    throw new AssertionError();
                }
                if (implementz.isEmpty()) break;
                out.print("    implements ");
                this.renderTypeSet(out, implementz);
                out.println();
                break;
            }
            case 1: {
                Set implementz = this.clazz.getImplements();
                if (!$assertionsDisabled && implementz == null) {
                    throw new AssertionError();
                }
                if (implementz.isEmpty()) break;
                out.print("    extends ");
                this.renderTypeSet(out, implementz);
                out.println();
                break;
            }
            case 2: {
                throw new UnsupportedFeatureException("enum");
            }
            default: {
                throw new InternalError("Invalid class type: " + type);
            }
        }
        out.println("{");
        this.renderFields(out);
        if (!this.clazz.getFields().isEmpty() && !this.clazz.getMethods().isEmpty()) {
            out.println();
        }
        this.renderMethods(out);
        if (!this.clazz.isInterface()) {
            if (!this.clazz.getFields().isEmpty() || !this.clazz.getMethods().isEmpty()) {
                out.println();
            }
            this.renderSyntheticMethods(out);
        }
        out.println("}");
    }

    protected void renderFields(PrintWriter out) {
        if (!$assertionsDisabled && out == null) {
            throw new AssertionError();
        }
        Set fields = this.clazz.getFields();
        if (!$assertionsDisabled && fields == null) {
            throw new AssertionError();
        }
        if (!fields.isEmpty()) {
            Iterator iter = fields.iterator();
            while (iter.hasNext()) {
                FieldDef def = (FieldDef)iter.next();
                if (def.isProperty()) {
                    this.renderProperty(out, def);
                } else {
                    this.renderField(out, def);
                }
                if (!iter.hasNext()) continue;
                out.println();
            }
        }
    }

    protected void renderField(PrintWriter out, FieldDef def) {
        if (!$assertionsDisabled && out == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && def == null) {
            throw new AssertionError();
        }
        this.renderJavaDoc(out, def, "    ");
        out.print("    ");
        if (!def.getParent().isInterface()) {
            this.renderModifiers(out, def);
        }
        TypeDef type = def.getType();
        this.renderType(out, type);
        out.print(" ");
        out.print(def.getName());
        out.print(" = ");
        out.print(type.getDefaultValue());
        out.println(";");
    }

    protected void renderProperty(PrintWriter out, FieldDef def) {
        if (!$assertionsDisabled && out == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && def == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && !def.isProperty()) {
            throw new AssertionError();
        }
        FieldDef field = new FieldDef();
        field.setParent(def.getParent());
        field.setJavaDoc(def.getJavaDoc());
        field.setType(def.getType());
        field.setName(def.getName());
        field.getModifiers().merge(def.getModifiers()).add("private");
        this.renderField(out, field);
        String name = this.capitalize(def.getName());
        MethodDef getter = new MethodDef();
        getter.setParent(def.getParent());
        getter.setName("get" + name);
        getter.setReturns(def.getType());
        getter.getModifiers().merge(def.getModifiers()).add("public");
        if (!this.definedMethods.containsKey(getter.signature())) {
            this.renderMethod(out, getter);
        }
        if (def.getType().isBoolean()) {
            MethodDef isser = new MethodDef();
            isser.setParent(def.getParent());
            isser.setName("is" + name);
            isser.setReturns(def.getType());
            isser.getModifiers().merge(def.getModifiers()).add("public");
            if (!this.definedMethods.containsKey(isser.signature())) {
                this.renderMethod(out, isser);
            }
        }
        if (!def.getModifiers().isFinal()) {
            MethodDef setter = new MethodDef();
            setter.setParent(def.getParent());
            setter.setName("set" + name);
            setter.setReturns(new TypeDef("void"));
            setter.addParameter(new ParameterDef(def.getType(), "value"));
            setter.getModifiers().merge(def.getModifiers()).add("public");
            if (!this.definedMethods.containsKey(setter.signature())) {
                this.renderMethod(out, setter);
            }
        }
    }

    protected String capitalize(String string) {
        if (!$assertionsDisabled && string == null) {
            throw new AssertionError();
        }
        int length = string.length();
        if (length == 0) {
            return string;
        }
        if (length == 1) {
            return string.toUpperCase();
        }
        return Character.toUpperCase(string.charAt(0)) + string.substring(1);
    }

    protected void renderSyntheticMethods(PrintWriter out) {
        if (!$assertionsDisabled && out == null) {
            throw new AssertionError();
        }
        MethodDef def = new MethodDef();
        def.setParent(this.clazz);
        def.getModifiers().add("public");
        def.setReturns(new TypeDef("groovy.lang.MetaClass"));
        def.setName("getMetaClass");
        if (!this.definedMethods.containsKey(def.signature())) {
            this.renderMethod(out, def);
            out.println();
        }
        def = new MethodDef();
        def.setParent(this.clazz);
        def.getModifiers().add("public");
        def.setReturns(new TypeDef("void"));
        def.setName("setMetaClass");
        def.addParameter(new ParameterDef("groovy.lang.MetaClass", "metaClass"));
        if (!this.definedMethods.containsKey(def.signature())) {
            this.renderMethod(out, def);
            out.println();
        }
        def = new MethodDef();
        def.setParent(this.clazz);
        def.getModifiers().add("public");
        def.setReturns(new TypeDef("java.lang.Object"));
        def.setName("invokeMethod");
        def.addParameter(new ParameterDef("java.lang.String", "name"));
        def.addParameter(new ParameterDef("java.lang.Object", "args"));
        if (!this.definedMethods.containsKey(def.signature())) {
            this.renderMethod(out, def);
            out.println();
        }
        def = new MethodDef();
        def.setParent(this.clazz);
        def.getModifiers().add("public");
        def.setReturns(new TypeDef("java.lang.Object"));
        def.setName("getProperty");
        def.addParameter(new ParameterDef("java.lang.String", "name"));
        if (!this.definedMethods.containsKey(def.signature())) {
            this.renderMethod(out, def);
            out.println();
        }
        def = new MethodDef();
        def.setParent(this.clazz);
        def.getModifiers().add("public");
        def.setReturns(new TypeDef("void"));
        def.setName("setProperty");
        def.addParameter(new ParameterDef("java.lang.String", "name"));
        def.addParameter(new ParameterDef("java.lang.Object", "value"));
        if (!this.definedMethods.containsKey(def.signature())) {
            this.renderMethod(out, def);
        }
    }

    protected void renderMethods(PrintWriter out) {
        if (!$assertionsDisabled && out == null) {
            throw new AssertionError();
        }
        if (!this.clazz.isInterface()) {
            this.renderMagicConstructors(out);
        }
        Set methods = this.clazz.getMethods();
        if (!$assertionsDisabled && methods == null) {
            throw new AssertionError();
        }
        if (!methods.isEmpty()) {
            Iterator iter = methods.iterator();
            while (iter.hasNext()) {
                MethodDef def = (MethodDef)iter.next();
                this.renderMethod(out, def);
                if (!iter.hasNext()) continue;
                out.println();
            }
        }
    }

    protected void renderMagicConstructors(PrintWriter out) {
        if (!$assertionsDisabled && out == null) {
            throw new AssertionError();
        }
        if (!this.clazz.getConstructors().isEmpty()) {
            ConstructorDef def = new ConstructorDef();
            def.setMagic(true);
            def.setParent(this.clazz);
            def.getModifiers().add("private");
            def.addParameter(new ParameterDef("java.lang.Void", "void1"));
            def.addParameter(new ParameterDef("java.lang.Void", "void2"));
            def.addParameter(new ParameterDef("java.lang.Void", "void3"));
            this.renderMethod(out, def);
            out.println();
        }
    }

    protected void renderMethod(PrintWriter out, MethodDef def) {
        if (!$assertionsDisabled && out == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && def == null) {
            throw new AssertionError();
        }
        MethodDef.Type type = def.getType();
        this.renderJavaDoc(out, def, "    ");
        out.print("    ");
        if (!def.getParent().isInterface()) {
            ModifiersDef modifiers = def.getModifiers();
            if (!modifiers.hasAccessModifiers()) {
                modifiers.add("public");
            }
            this.renderModifiers(out, def);
        }
        if (type == MethodDef.Type.METHOD) {
            this.renderType(out, def.getReturns());
            out.print(" ");
        }
        out.print(def.getName());
        out.print("(");
        this.renderParameters(out, def.getParameters());
        out.print(")");
        Set throwz = def.getThrows();
        if (!$assertionsDisabled && throwz == null) {
            throw new AssertionError();
        }
        if (!throwz.isEmpty()) {
            out.print(" throws ");
            this.renderTypeSet(out, throwz);
        }
        if (def.getParent().isInterface() || def.getModifiers().isAbstract() || def.getModifiers().isNative()) {
            out.println(";");
        } else {
            out.println(" {");
            if (def.isConstructor()) {
                if (!$assertionsDisabled && !(def instanceof ConstructorDef)) {
                    throw new AssertionError();
                }
                ConstructorDef ctor = (ConstructorDef)def;
                if (ctor.isMagic()) {
                    this.renderMagicConstructorSuper(out, ctor);
                } else {
                    this.renderMagicConstructorInvoke(out, ctor);
                }
            }
            out.println("        throw new InternalError(\"Stubbed method\");");
            out.println("    }");
        }
    }

    protected void renderMagicConstructorSuper(PrintWriter out, ConstructorDef def) {
        if (!$assertionsDisabled && out == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && def == null) {
            throw new AssertionError();
        }
        Set parameters = this.selectMagicConstructorSuperParameters(def);
        if (parameters != null) {
            out.print("        super");
            out.print("(");
            if (!parameters.isEmpty()) {
                Iterator iter = parameters.iterator();
                while (iter.hasNext()) {
                    SuperParameterDef param = (SuperParameterDef)iter.next();
                    this.renderSuperParameter(out, param);
                    if (!iter.hasNext()) continue;
                    out.print(", ");
                }
            }
            out.println(");");
            out.println();
        }
    }

    protected Set selectMagicConstructorSuperParameters(ConstructorDef target) {
        if (!$assertionsDisabled && target == null) {
            throw new AssertionError();
        }
        Iterator iter = target.getParent().getConstructors().iterator();
        block0: while (iter.hasNext()) {
            Set parameters;
            ConstructorDef def = (ConstructorDef)iter.next();
            if (def.isMagic() || !"super".equals(def.getSuperType()) || (parameters = def.getSuperParameters()) == null || parameters.isEmpty()) continue;
            Iterator iter2 = parameters.iterator();
            while (iter2.hasNext()) {
                SuperParameterDef param = (SuperParameterDef)iter2.next();
                if (param.getType() != null) continue;
                continue block0;
            }
            return parameters;
        }
        return null;
    }

    protected void renderMagicConstructorInvoke(PrintWriter out, ConstructorDef def) {
        if (!$assertionsDisabled && out == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && def == null) {
            throw new AssertionError();
        }
        out.println("        this((java.lang.Void)null, (java.lang.Void)null, (java.lang.Void)null);");
    }

    protected void renderSuperParameters(PrintWriter out, ConstructorDef def) {
        if (!$assertionsDisabled && out == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && def == null) {
            throw new AssertionError();
        }
        String superType = def.getSuperType();
        if (superType != null) {
            out.print("        ");
            out.print(superType);
            out.print("(");
            Set params = def.getSuperParameters();
            if (!params.isEmpty()) {
                Iterator iter = params.iterator();
                while (iter.hasNext()) {
                    SuperParameterDef param = (SuperParameterDef)iter.next();
                    this.renderSuperParameter(out, param);
                    if (!iter.hasNext()) continue;
                    out.print(", ");
                }
            }
            out.println(");");
            out.println();
        }
    }

    protected void renderSuperParameter(PrintWriter out, SuperParameterDef def) {
        if (!$assertionsDisabled && out == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && def == null) {
            throw new AssertionError();
        }
        TypeDef type = def.getType();
        if (type == null) {
            out.print("null");
        } else {
            out.print("(");
            this.renderType(out, type);
            out.print(")");
            out.print(type.getDefaultValue());
        }
    }

    protected void renderParameters(PrintWriter out, Set parameters) {
        if (!$assertionsDisabled && out == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && parameters == null) {
            throw new AssertionError();
        }
        Iterator iter = parameters.iterator();
        while (iter.hasNext()) {
            ParameterDef def = (ParameterDef)iter.next();
            this.renderParameter(out, def);
            if (!iter.hasNext()) continue;
            out.print(", ");
        }
    }

    protected void renderParameter(PrintWriter out, ParameterDef def) {
        if (!$assertionsDisabled && out == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && def == null) {
            throw new AssertionError();
        }
        if (!def.getParent().getParent().isInterface()) {
            this.renderModifiers(out, def);
        }
        this.renderType(out, def.getType());
        out.print(" ");
        out.print(def.getName());
    }

    static {
        $assertionsDisabled = !RendererSupport.class.desiredAssertionStatus();
    }
}

