/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.jdt.groovy.internal.compiler.ast;

import groovy.lang.GroovyClassLoader;
import groovy.lang.GroovySystem;
import java.io.File;
import java.lang.ref.WeakReference;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.Set;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.classgen.GeneratorContext;
import org.codehaus.groovy.control.CompilationFailedException;
import org.codehaus.groovy.control.CompilationUnit;
import org.codehaus.groovy.control.SourceUnit;
import org.codehaus.groovy.control.customizers.ASTTransformationCustomizer;
import org.codehaus.groovy.control.customizers.ImportCustomizer;
import org.codehaus.jdt.groovy.control.EclipseSourceUnit;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.internal.compiler.impl.CompilerOptions;

public class Grails20TestSupport {
    public static boolean DEBUG = false;
    private static final String GRAILS_UTIL_BUILD_SETTINGS = "grails.util.BuildSettings";
    private static final String GRAILS_UTIL_BUILD_SETTINGS_HOLDER = "grails.util.BuildSettingsHolder";
    CompilerOptions options;
    GroovyClassLoader gcl;

    private static Object getField(Object o, String name) throws Exception {
        Class<?> c = o.getClass();
        Field f = Grails20TestSupport.lookupField(c, name);
        f.setAccessible(true);
        return f.get(o);
    }

    private static Field lookupField(Class c, String name) throws Exception {
        block3: {
            if (c != null) {
                try {
                    return c.getDeclaredField(name);
                }
                catch (NoSuchFieldException e) {
                    Class parent = c.getSuperclass();
                    if (parent == null) break block3;
                    return Grails20TestSupport.lookupField(parent, name);
                }
            }
        }
        return null;
    }

    private static void debug(String msg) {
        if (DEBUG) {
            System.out.println("Grails20TestSupport: " + msg);
        }
    }

    public Grails20TestSupport(CompilerOptions options, GroovyClassLoader gcl) {
        this.options = options;
        this.gcl = gcl;
    }

    public void addGrailsTestCompilerCustomizers(CompilationUnit groovyCompilationUnit) {
        String groovyVersion = GroovySystem.getVersion();
        if (groovyVersion.startsWith("1.8") || groovyVersion.startsWith("2.")) {
            ImportCustomizer importCustomizer = new ImportCustomizer(){

                public void call(SourceUnit source, GeneratorContext context, ClassNode classNode) throws CompilationFailedException {
                    if (Grails20TestSupport.isInGrailsUnitTestSourceFolder(source)) {
                        super.call(source, context, classNode);
                    }
                }
            };
            importCustomizer.addStarImports("grails.test.mixin");
            importCustomizer.addStarImports("org.junit");
            importCustomizer.addStaticStars("org.junit.Assert");
            groovyCompilationUnit.addPhaseOperation(importCustomizer, importCustomizer.getPhase().getPhaseNumber());
            Class<?> testForClass = null;
            try {
                testForClass = Class.forName("grails.test.mixin.TestFor", false, this.gcl);
                if (testForClass != null) {
                    ASTTransformationCustomizer astTransformationCustomizer = new ASTTransformationCustomizer(testForClass){

                        public void call(SourceUnit source, GeneratorContext context, ClassNode classNode) throws CompilationFailedException {
                            if (Grails20TestSupport.isInGrailsUnitTestSourceFolder(source)) {
                                super.call(source, context, classNode);
                            }
                        }
                    };
                    groovyCompilationUnit.addPhaseOperation(astTransformationCustomizer, astTransformationCustomizer.getPhase().getPhaseNumber());
                    this.ensureGrailsBuildSettings();
                }
            }
            catch (LinkageError astTransformationCustomizer) {
            }
            catch (ClassNotFoundException astTransformationCustomizer) {
            }
            catch (Exception e) {
                e.printStackTrace(System.err);
            }
        }
    }

    void ensureGrailsBuildSettings() {
        block7: {
            Grails20TestSupport.debug("entering ensureGrailsBuildSettings");
            ThreadLocalCleaner cleaner = new ThreadLocalCleaner();
            try {
                try {
                    String projectName = this.options.groovyProjectName;
                    Grails20TestSupport.debug("projectName = " + projectName);
                    if (projectName != null) {
                        Class<?> buildSettingsHolder = this.gcl.loadClass(GRAILS_UTIL_BUILD_SETTINGS_HOLDER);
                        Grails20TestSupport.debug("buildSettingsHolder = " + buildSettingsHolder);
                        Object buildSettings = Grails20TestSupport.getBuildSettings(buildSettingsHolder);
                        Grails20TestSupport.debug("buildSettings = " + buildSettings);
                        if (buildSettings == null) {
                            Grails20TestSupport.debug("Creating buildSettings");
                            buildSettings = this.createBuildSettings();
                            Grails20TestSupport.debug("created buildSettings = " + buildSettingsHolder);
                            Grails20TestSupport.setBuildSettings(buildSettingsHolder, buildSettings);
                            Object checkit = Grails20TestSupport.getBuildSettings(buildSettingsHolder);
                            Grails20TestSupport.debug("set and get buildsettings = " + checkit);
                        }
                    }
                }
                catch (Exception e) {
                    Grails20TestSupport.debug("FAILED ensureGrailsBuildSettings");
                    e.printStackTrace();
                    cleaner.cleanup();
                    break block7;
                }
            }
            catch (Throwable throwable) {
                cleaner.cleanup();
                throw throwable;
            }
            cleaner.cleanup();
        }
        Grails20TestSupport.debug("exiting ensureGrailsBuildSettings");
    }

    private Object createBuildSettings() throws ClassNotFoundException, SecurityException, NoSuchMethodException, IllegalArgumentException, InstantiationException, IllegalAccessException, InvocationTargetException {
        Class<?> buildSettingsClass = this.gcl.loadClass(GRAILS_UTIL_BUILD_SETTINGS);
        Grails20TestSupport.debug("BuildSettingsClass = " + buildSettingsClass);
        Constructor<?> constructor = buildSettingsClass.getConstructor(File.class, File.class);
        Grails20TestSupport.debug("Constructor = " + constructor);
        Object grailsHome = this.getGrailsHome();
        Grails20TestSupport.debug("grailsHome = " + grailsHome);
        File projectHome = this.getProjectHome();
        Grails20TestSupport.debug("projectHome = " + projectHome);
        return constructor.newInstance(grailsHome, projectHome);
    }

    private Object getGrailsHome() {
        return null;
    }

    private File getProjectHome() {
        IProject project;
        IPath location;
        String projectName = this.options.groovyProjectName;
        if (projectName != null && (location = (project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName)).getLocation()) != null) {
            return location.toFile();
        }
        return null;
    }

    private static Object getBuildSettings(Class buildSettingsHolder) throws SecurityException, NoSuchMethodException, IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        Method m = buildSettingsHolder.getMethod("getSettings", new Class[0]);
        return m.invoke(null, new Object[0]);
    }

    private static synchronized void setBuildSettings(Class buildSettingsHolder, Object buildSettings) throws SecurityException, NoSuchMethodException, ClassNotFoundException, IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        Method m = buildSettingsHolder.getMethod("setSettings", buildSettingsHolder.getClassLoader().loadClass(GRAILS_UTIL_BUILD_SETTINGS));
        m.invoke(null, buildSettings);
        Assert.isTrue(Grails20TestSupport.getBuildSettings(buildSettingsHolder) == buildSettings);
    }

    static boolean isInGrailsUnitTestSourceFolder(SourceUnit source) {
        EclipseSourceUnit eclipseSource;
        IFile file;
        if (source instanceof EclipseSourceUnit && (file = (eclipseSource = (EclipseSourceUnit)source).getEclipseFile()) != null) {
            IPath path = file.getProjectRelativePath();
            return new Path("test/unit").isPrefixOf(path);
        }
        return false;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ThreadLocalCleaner {
        private Set<ThreadLocal> initialSet;

        public ThreadLocalCleaner() {
            try {
                this.initialSet = this.currentThreadLocals();
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }

        private Set<ThreadLocal> currentThreadLocals() throws Exception {
            Object[] entries;
            HashSet<ThreadLocal> initialSet = new HashSet<ThreadLocal>();
            Thread t = Thread.currentThread();
            Object threadLocalMap = Grails20TestSupport.getField(t, "threadLocals");
            if (threadLocalMap != null && (entries = (Object[])Grails20TestSupport.getField(threadLocalMap, "table")) != null) {
                Object[] objectArray = entries;
                int n = entries.length;
                int n2 = 0;
                while (n2 < n) {
                    ThreadLocal tl;
                    Object object = objectArray[n2];
                    WeakReference ref = (WeakReference)object;
                    if (ref != null && (tl = (ThreadLocal)ref.get()) != null) {
                        initialSet.add(tl);
                    }
                    ++n2;
                }
            }
            return initialSet;
        }

        public void cleanup() {
            if (this.initialSet != null) {
                try {
                    Set<ThreadLocal> currentSet = this.currentThreadLocals();
                    for (ThreadLocal tl : currentSet) {
                        if (this.initialSet.contains(tl)) continue;
                        tl.remove();
                    }
                }
                catch (Throwable e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

