/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.groovy.core.util;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.groovy.core.Activator;
import org.eclipse.jdt.internal.compiler.ast.Annotation;
import org.eclipse.jdt.internal.core.JavaElement;
import org.eclipse.jdt.internal.core.LocalVariable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReflectionUtils {
    private static final Class[] NO_TYPES = new Class[0];
    private static final Object[] NO_ARGS = new Object[0];
    private static Map<String, Field> fieldMap = new HashMap<String, Field>();

    public static <T> Object getPrivateField(Class<T> clazz, String fieldName, Object target) {
        String key = String.valueOf(clazz.getCanonicalName()) + fieldName;
        Field field = fieldMap.get(key);
        try {
            if (field == null) {
                field = clazz.getDeclaredField(fieldName);
                field.setAccessible(true);
                fieldMap.put(key, field);
            }
            return field.get(target);
        }
        catch (Exception e) {
            Activator.getDefault().getLog().log(new Status(4, "org.eclipse.jdt.groovy.core", "Error getting private field '" + fieldName + "' on class " + clazz, e));
            return null;
        }
    }

    public static <T> void setPrivateField(Class<T> clazz, String fieldName, Object target, Object newValue) {
        String key = String.valueOf(clazz.getCanonicalName()) + fieldName;
        Field field = fieldMap.get(key);
        try {
            if (field == null) {
                field = clazz.getDeclaredField(fieldName);
                field.setAccessible(true);
                fieldMap.put(key, field);
            }
            field.set(target, newValue);
        }
        catch (Exception e) {
            Activator.getDefault().getLog().log(new Status(4, "org.eclipse.jdt.groovy.core", "Error setting private field '" + fieldName + "' on class " + clazz, e));
        }
    }

    public static <T> Object executeNoArgPrivateMethod(Class<T> clazz, String methodName, Object target) {
        return ReflectionUtils.executePrivateMethod(clazz, methodName, NO_TYPES, target, NO_ARGS);
    }

    public static <T> Object executePrivateMethod(Class<T> clazz, String methodName, Class<?>[] types, Object target, Object[] args) {
        try {
            Method method = clazz.getDeclaredMethod(methodName, types);
            method.setAccessible(true);
            return method.invoke(target, args);
        }
        catch (Exception e) {
            Activator.getDefault().getLog().log(new Status(4, "org.eclipse.jdt.groovy.core", "Error executing private method '" + methodName + "' on class " + clazz, e));
            return null;
        }
    }

    public static <T> Object throwableExecutePrivateMethod(Class<T> clazz, String methodName, Class<?>[] types, T target, Object[] args) throws Exception {
        Method method = clazz.getDeclaredMethod(methodName, types);
        method.setAccessible(true);
        return method.invoke(target, args);
    }

    public static <T> Object throwableGetPrivateField(Class<T> clazz, String fieldName, T target) throws Exception {
        String key = String.valueOf(clazz.getCanonicalName()) + fieldName;
        Field field = fieldMap.get(key);
        if (field == null) {
            field = clazz.getDeclaredField(fieldName);
            field.setAccessible(true);
            fieldMap.put(key, field);
        }
        return field.get(target);
    }

    public static LocalVariable createLocalVariable(IJavaElement parent, String varName, int start, String returnTypeSignature) {
        try {
            Constructor cons = LocalVariable.class.getConstructor(JavaElement.class, String.class, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, String.class, Annotation[].class);
            LocalVariable localVariable = (LocalVariable)cons.newInstance(parent, varName, start, start + varName.length() - 1, start, start + varName.length() - 1, returnTypeSignature, new Annotation[0]);
            return localVariable;
        }
        catch (Exception e) {
            try {
                Constructor cons = LocalVariable.class.getConstructor(JavaElement.class, String.class, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, String.class, Annotation[].class, Integer.TYPE, Boolean.TYPE);
                LocalVariable localVariable = (LocalVariable)cons.newInstance(parent, varName, start, start + varName.length() - 1, start, start + varName.length() - 1, returnTypeSignature, new Annotation[0], 0, false);
                return localVariable;
            }
            catch (Exception e1) {
                Activator.getDefault().getLog().log(new Status(4, "org.eclipse.jdt.groovy.core", "Error creating local variable'" + varName + "' in element " + parent.getHandleIdentifier(), e));
                return null;
            }
        }
    }

    public static <T> T executePrivateConstructor(Class<T> clazz, Class<? extends Object>[] parameterTypes, Object[] args) {
        try {
            Constructor<T> constructor = clazz.getDeclaredConstructor(parameterTypes);
            constructor.setAccessible(true);
            return constructor.newInstance(args);
        }
        catch (Exception e) {
            Activator.getDefault().getLog().log(new Status(4, "org.eclipse.jdt.groovy.core", "Error executing private constructor for '" + clazz.getName() + "' on class " + clazz, e));
            return null;
        }
    }
}

