/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.natives.msvc;

import org.codehaus.mojo.natives.EnvFactory;
import org.codehaus.mojo.natives.NativeBuildException;
import org.codehaus.mojo.natives.linker.Manifest;
import org.codehaus.mojo.natives.linker.ManifestConfiguration;
import org.codehaus.mojo.natives.util.CommandLineUtil;
import org.codehaus.mojo.natives.util.EnvUtil;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.logging.AbstractLogEnabled;
import org.codehaus.plexus.logging.Logger;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.cli.Commandline;

@Component(role=Manifest.class, hint="msvc", instantiationStrategy="per-lookup")
public class MSVCManifest
extends AbstractLogEnabled
implements Manifest {
    public void run(ManifestConfiguration config) throws NativeBuildException {
        Commandline cl = new Commandline();
        cl.setExecutable("mt.exe");
        cl.setWorkingDirectory(config.getWorkingDirectory().getPath());
        cl.createArg().setValue("-manifest");
        int manifestType = 0;
        if ("EXE".equalsIgnoreCase(FileUtils.getExtension((String)config.getInputFile().getPath()))) {
            manifestType = 1;
        } else if ("DLL".equalsIgnoreCase(FileUtils.getExtension((String)config.getInputFile().getPath()))) {
            manifestType = 2;
        }
        if (manifestType == 0) {
            throw new NativeBuildException("Unknown manifest input file type: " + config.getInputFile());
        }
        cl.createArg().setFile(config.getManifestFile());
        cl.createArg().setValue("-outputresource:" + config.getInputFile() + ";" + manifestType);
        EnvUtil.setupCommandlineEnv((Commandline)cl, (EnvFactory)config.getEnvFactory());
        CommandLineUtil.execute((Commandline)cl, (Logger)this.getLogger());
    }
}

