/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.appassembler.daemon.booter;

import java.io.File;
import org.apache.maven.project.MavenProject;
import org.codehaus.mojo.appassembler.daemon.DaemonGenerationRequest;
import org.codehaus.mojo.appassembler.daemon.DaemonGenerator;
import org.codehaus.mojo.appassembler.daemon.DaemonGeneratorException;
import org.codehaus.mojo.appassembler.daemon.script.AbstactScriptDaemonGenerator;
import org.codehaus.mojo.appassembler.model.Classpath;
import org.codehaus.mojo.appassembler.model.Daemon;
import org.codehaus.mojo.appassembler.model.Directory;
import org.codehaus.mojo.appassembler.model.JvmSettings;
import org.codehaus.mojo.appassembler.util.DependencyFactory;

public abstract class AbstractBooterDaemonGenerator
extends AbstactScriptDaemonGenerator {
    private DaemonGenerator genericDaemonGenerator;

    protected AbstractBooterDaemonGenerator(String platformName) {
        super(platformName);
    }

    @Override
    public void generate(DaemonGenerationRequest request) throws DaemonGeneratorException {
        Daemon daemon = request.getDaemon();
        JvmSettings jvmSettings = daemon.getJvmSettings();
        File outputDirectory = request.getOutputDirectory();
        request.setOutputDirectory(new File(outputDirectory, "etc"));
        daemon.setJvmSettings(null);
        this.genericDaemonGenerator.generate(request);
        daemon.setJvmSettings(jvmSettings);
        Daemon booterDaemon = new Daemon();
        booterDaemon.setId(daemon.getId());
        booterDaemon.setName(daemon.getId());
        booterDaemon.setLongName(daemon.getId());
        booterDaemon.setMainClass("org.codehaus.mojo.appassembler.booter.AppassemblerBooter");
        Classpath classpath = new Classpath();
        booterDaemon.setClasspath(classpath);
        booterDaemon.setConfigurationDirectory(daemon.getConfigurationDirectory());
        booterDaemon.setJvmSettings(jvmSettings);
        booterDaemon.setEnvironmentSetupFileName(daemon.getEnvironmentSetupFileName());
        booterDaemon.setShowConsoleWindow(daemon.isShowConsoleWindow());
        booterDaemon.setRepositoryName(daemon.getRepositoryName());
        booterDaemon.setLicenseHeaderFile(daemon.getLicenseHeaderFile());
        booterDaemon.setEndorsedDir(daemon.getEndorsedDir());
        booterDaemon.setModelEncoding(daemon.getModelEncoding());
        MavenProject project = request.getMavenProject();
        classpath.addDirectory(AbstractBooterDaemonGenerator.createDirectory("etc"));
        classpath.addDependency(DependencyFactory.create(project, "org.codehaus.mojo.appassembler:appassembler-booter", request.getRepositoryLayout(), request.getOutputFileNameMapping()));
        classpath.addDependency(DependencyFactory.create(project, "org.codehaus.mojo.appassembler:appassembler-model", request.getRepositoryLayout(), request.getOutputFileNameMapping()));
        classpath.addDependency(DependencyFactory.create(project, "org.codehaus.plexus:plexus-utils", request.getRepositoryLayout(), request.getOutputFileNameMapping()));
        classpath.addDependency(DependencyFactory.create(project, "stax:stax-api", request.getRepositoryLayout(), request.getOutputFileNameMapping()));
        classpath.addDependency(DependencyFactory.create(project, "stax:stax", request.getRepositoryLayout(), request.getOutputFileNameMapping()));
        this.scriptGenerator.createBinScript(this.getPlatformName(), booterDaemon, outputDirectory, "bin");
    }

    private static Directory createDirectory(String relativePath) {
        Directory directory = new Directory();
        directory.setRelativePath(relativePath);
        return directory;
    }
}

