/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.appassembler.util;

import java.io.File;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.repository.layout.ArtifactRepositoryLayout;
import org.apache.maven.project.MavenProject;
import org.apache.maven.shared.mapping.MappingUtils;
import org.codehaus.mojo.appassembler.daemon.DaemonGeneratorException;
import org.codehaus.mojo.appassembler.model.Dependency;
import org.codehaus.mojo.appassembler.util.ArtifactUtils;
import org.codehaus.plexus.interpolation.InterpolationException;
import org.codehaus.plexus.util.StringUtils;

public class DependencyFactory {
    private DependencyFactory() {
    }

    public static Dependency create(Artifact artifact, ArtifactRepositoryLayout layout, String outputFileNameMapping) {
        Dependency dependency = new Dependency();
        dependency.setGroupId(artifact.getGroupId());
        dependency.setArtifactId(artifact.getArtifactId());
        dependency.setVersion(artifact.getVersion());
        dependency.setClassifier(artifact.getClassifier());
        String path = layout.pathOf(artifact);
        if (StringUtils.isNotEmpty((String)outputFileNameMapping)) {
            File directory = new File(path).getParentFile();
            try {
                String fileName = MappingUtils.evaluateFileNameMapping((String)outputFileNameMapping, (Artifact)artifact);
                File file = new File(directory, fileName);
                path = file.getPath().replace('\\', '/');
            }
            catch (InterpolationException interpolationException) {
                // empty catch block
            }
        }
        dependency.setRelativePath(path);
        return dependency;
    }

    public static Dependency create(Artifact artifact, ArtifactRepositoryLayout layout, boolean useTimestampInSnapshotFileName, String outputFileNameMapping) {
        Dependency dependency = DependencyFactory.create(artifact, layout, outputFileNameMapping);
        if (artifact.isSnapshot() && !useTimestampInSnapshotFileName) {
            dependency.setRelativePath(ArtifactUtils.pathBaseVersionOf(layout, artifact));
        }
        return dependency;
    }

    public static Dependency create(MavenProject project, String id, ArtifactRepositoryLayout layout, String outputFileNameMapping) throws DaemonGeneratorException {
        Artifact artifact = (Artifact)project.getArtifactMap().get(id);
        if (artifact == null) {
            throw new DaemonGeneratorException("The project has to have a dependency on '" + id + "'.");
        }
        return DependencyFactory.create(artifact, layout, outputFileNameMapping);
    }
}

