/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.clirr;

import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.PrintStream;
import net.sf.clirr.core.ApiDifference;
import net.sf.clirr.core.DiffListener;
import net.sf.clirr.core.MessageTranslator;

public class TypeRevealingXmlDiffListener
implements DiffListener {
    private static final String DIFFREPORT = "diffreport";
    private static final String DIFFERENCE = "difference";
    private final MessageTranslator translator = new MessageTranslator();
    private final PrintStream out;

    public TypeRevealingXmlDiffListener(String outFile) throws FileNotFoundException {
        this.out = new PrintStream(new FileOutputStream(outFile));
    }

    public void reportDiff(ApiDifference difference) {
        this.out.print("  <difference");
        this.out.print(" type=\"" + difference.getMessage().getId() + "\"");
        this.out.print(" binseverity=\"" + difference.getBinaryCompatibilitySeverity() + "\"");
        this.out.print(" srcseverity=\"" + difference.getSourceCompatibilitySeverity() + "\"");
        this.out.print(" class=\"" + difference.getAffectedClass() + "\"");
        if (difference.getAffectedMethod() != null) {
            this.out.print(" method=\"" + difference.getAffectedMethod() + "\"");
        }
        if (difference.getAffectedField() != null) {
            this.out.print(" field=\"" + difference.getAffectedField() + "\"");
        }
        this.out.print(">");
        this.out.print(difference.getReport(this.translator));
        this.out.println("</difference>");
    }

    public void start() {
        this.out.println("<?xml version=\"1.0\"?>");
        this.out.println("<diffreport>");
    }

    public void stop() {
        this.out.println("</diffreport>");
        this.out.close();
    }
}

