/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.exec;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;

class URLClassLoaderBuilder {
    private Collection<Path> paths;

    private URLClassLoaderBuilder() {
    }

    static URLClassLoaderBuilder builder() {
        return new URLClassLoaderBuilder();
    }

    URLClassLoaderBuilder setPaths(Collection<Path> paths) {
        this.paths = paths;
        return this;
    }

    ClassLoader build() throws IOException {
        ArrayList<URL> urls = new ArrayList<URL>(this.paths.size());
        for (Path dependency : this.paths) {
            try {
                urls.add(dependency.toUri().toURL());
            }
            catch (MalformedURLException e) {
                throw new IOException("Error during setting up classpath", e);
            }
        }
        return new URLClassLoader(urls.toArray(new URL[0]));
    }
}

