/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.flatten;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.inject.Inject;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.maven.RepositoryUtils;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.handler.manager.ArtifactHandlerManager;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Activation;
import org.apache.maven.model.Build;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.DependencyManagement;
import org.apache.maven.model.Exclusion;
import org.apache.maven.model.Model;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.Profile;
import org.apache.maven.model.Repository;
import org.apache.maven.model.RepositoryPolicy;
import org.apache.maven.model.building.DefaultModelBuildingRequest;
import org.apache.maven.model.building.ModelBuildingException;
import org.apache.maven.model.building.ModelBuildingRequest;
import org.apache.maven.model.building.ModelBuildingResult;
import org.apache.maven.model.building.ModelProblemCollector;
import org.apache.maven.model.interpolation.ModelInterpolator;
import org.apache.maven.model.io.xpp3.MavenXpp3Reader;
import org.apache.maven.model.io.xpp3.MavenXpp3Writer;
import org.apache.maven.model.profile.DefaultProfileSelector;
import org.apache.maven.model.profile.ProfileInjector;
import org.apache.maven.model.profile.ProfileSelector;
import org.apache.maven.model.resolution.ModelResolver;
import org.apache.maven.plugin.MojoExecution;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.codehaus.mojo.flatten.AbstractFlattenMojo;
import org.codehaus.mojo.flatten.Dependencies;
import org.codehaus.mojo.flatten.DirectDependenciesInheritanceAssembler;
import org.codehaus.mojo.flatten.ElementHandling;
import org.codehaus.mojo.flatten.FlattenDependencyMode;
import org.codehaus.mojo.flatten.FlattenDescriptor;
import org.codehaus.mojo.flatten.FlattenMode;
import org.codehaus.mojo.flatten.KeepCommentsInPom;
import org.codehaus.mojo.flatten.LoggingModelProblemCollector;
import org.codehaus.mojo.flatten.ModelBuilderThreadSafetyWorkaround;
import org.codehaus.mojo.flatten.PomProperty;
import org.codehaus.mojo.flatten.cifriendly.CiInterpolator;
import org.codehaus.mojo.flatten.model.resolution.FlattenModelResolver;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;
import org.eclipse.aether.DefaultRepositorySystemSession;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.RequestTrace;
import org.eclipse.aether.artifact.ArtifactTypeRegistry;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.collection.CollectRequest;
import org.eclipse.aether.collection.CollectResult;
import org.eclipse.aether.collection.DependencyCollectionException;
import org.eclipse.aether.graph.DependencyNode;
import org.eclipse.aether.graph.DependencyVisitor;
import org.eclipse.aether.resolution.ArtifactDescriptorException;
import org.eclipse.aether.resolution.ArtifactDescriptorRequest;
import org.eclipse.aether.resolution.ArtifactDescriptorResult;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.ext.DefaultHandler2;
import org.xml.sax.helpers.DefaultHandler;

@Mojo(name="flatten", requiresDependencyCollection=ResolutionScope.RUNTIME, threadSafe=true)
public class FlattenMojo
extends AbstractFlattenMojo {
    private static final int INITIAL_POM_WRITER_SIZE = 4096;
    @Parameter(defaultValue="${session}", readonly=true, required=true)
    private MavenSession session;
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    private MavenProject project;
    @Parameter(property="updatePomFile")
    private Boolean updatePomFile;
    @Parameter(defaultValue="false")
    private Boolean embedBuildProfileDependencies;
    @Parameter(defaultValue="${mojo}", readonly=true, required=true)
    private MojoExecution mojoExecution;
    @Parameter(required=false)
    private FlattenDescriptor pomElements;
    @Parameter(defaultValue="false", required=false)
    private boolean omitExclusions;
    @Parameter(property="flatten.mode", required=false)
    private FlattenMode flattenMode;
    @Parameter(property="flatten.dependency.mode", required=false)
    private FlattenDependencyMode flattenDependencyMode;
    @Parameter(property="flatten.dependency.keepComments", required=false, defaultValue="false")
    private boolean keepCommentsInPom;
    @Inject
    private DirectDependenciesInheritanceAssembler inheritanceAssembler;
    @Inject
    private ModelInterpolator modelInterpolator;
    @Inject
    private CiInterpolator modelCiFriendlyInterpolator;
    @Inject
    private ModelBuilderThreadSafetyWorkaround modelBuilderThreadSafetyWorkaround;
    @Inject
    private ArtifactHandlerManager artifactHandlerManager;
    @Inject
    private RepositorySystem repositorySystem;

    public void execute() throws MojoExecutionException, MojoFailureException {
        this.getLog().info((CharSequence)("Generating flattened POM of project " + this.project.getId() + "..."));
        this.inheritanceAssembler.flattenDependencyMode = this.flattenDependencyMode;
        File originalPomFile = this.project.getFile();
        KeepCommentsInPom commentsOfOriginalPomFile = null;
        if (this.keepCommentsInPom) {
            commentsOfOriginalPomFile = KeepCommentsInPom.create(this.getLog(), originalPomFile);
        }
        Model flattenedPom = this.createFlattenedPom(originalPomFile);
        String headerComment = this.extractHeaderComment(originalPomFile);
        File flattenedPomFile = this.getFlattenedPomFile();
        this.writePom(flattenedPom, flattenedPomFile, headerComment, commentsOfOriginalPomFile);
        if (this.isUpdatePomFile()) {
            this.project.setPomFile(flattenedPomFile);
            this.project.setOriginalModel(flattenedPom);
        }
    }

    protected String extractHeaderComment(File xmlFile) throws MojoExecutionException {
        try {
            SAXParser parser = SAXParserFactory.newInstance().newSAXParser();
            SaxHeaderCommentHandler handler = new SaxHeaderCommentHandler();
            parser.setProperty("http://xml.org/sax/properties/lexical-handler", handler);
            parser.parse(xmlFile, (DefaultHandler)handler);
            return handler.getHeaderComment();
        }
        catch (Exception e) {
            throw new MojoExecutionException("Failed to parse XML from " + xmlFile, e);
        }
    }

    protected void writePom(Model pom, File pomFile, String headerComment, KeepCommentsInPom anOriginalCommentsPath) throws MojoExecutionException {
        boolean success;
        File parentFile = pomFile.getParentFile();
        if (!parentFile.exists() && !(success = parentFile.mkdirs())) {
            throw new MojoExecutionException("Failed to create directory " + pomFile.getParent());
        }
        MavenXpp3Writer pomWriter = new MavenXpp3Writer();
        StringWriter stringWriter = new StringWriter(4096);
        try {
            pomWriter.write((Writer)stringWriter, pom);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Internal I/O error!", (Exception)e);
        }
        StringBuffer buffer = stringWriter.getBuffer();
        if (!StringUtils.isEmpty((String)headerComment)) {
            int projectStartIndex = buffer.indexOf("<project");
            if (projectStartIndex >= 0) {
                buffer.insert(projectStartIndex, "<!--" + headerComment + "-->\n");
            } else {
                this.getLog().warn((CharSequence)"POM XML post-processing failed: no project tag found!");
            }
        }
        String xmlString = anOriginalCommentsPath == null ? buffer.toString() : anOriginalCommentsPath.restoreOriginalComments(buffer.toString(), pom.getModelEncoding());
        this.writeStringToFile(xmlString, pomFile, pom.getModelEncoding());
    }

    protected void writeStringToFile(String data, File file, String encoding) throws MojoExecutionException {
        byte[] binaryData;
        block22: {
            if (!"\n".equals(System.lineSeparator())) {
                data = data.replace("\n", System.lineSeparator());
            }
            try {
                binaryData = data.getBytes(encoding);
                if (file.isFile() && file.canRead() && file.length() == (long)binaryData.length) {
                    try (InputStream inputStream = Files.newInputStream(file.toPath(), new OpenOption[0]);){
                        byte[] buffer = new byte[binaryData.length];
                        inputStream.read(buffer);
                        if (Arrays.equals(buffer, binaryData)) {
                            this.getLog().debug((CharSequence)"Arrays.equals( buffer, binaryData ) ");
                            return;
                        }
                        this.getLog().debug((CharSequence)"Not Arrays.equals( buffer, binaryData ) ");
                        break block22;
                    }
                    catch (IOException e) {
                        this.getLog().debug((CharSequence)("Issue reading file: " + file.getPath()), (Throwable)e);
                    }
                    break block22;
                }
                this.getLog().debug((CharSequence)("file: " + file + ",file.length(): " + file.length() + ", binaryData.length: " + binaryData.length));
            }
            catch (IOException e) {
                throw new MojoExecutionException("cannot read String as bytes", (Exception)e);
            }
        }
        try (OutputStream outStream = Files.newOutputStream(file.toPath(), new OpenOption[0]);){
            outStream.write(binaryData);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Failed to write to " + file, (Exception)e);
        }
    }

    protected Model createFlattenedPom(File pomFile) throws MojoExecutionException, MojoFailureException {
        Model cleanPom;
        ModelBuildingRequest buildingRequest = this.createModelBuildingRequest(pomFile);
        Model effectivePom = this.createEffectivePom(buildingRequest, this.isEmbedBuildProfileDependencies(), this.flattenMode);
        Model flattenedPom = new Model();
        String modelEncoding = effectivePom.getModelEncoding();
        if (StringUtils.isEmpty((String)modelEncoding)) {
            modelEncoding = "UTF-8";
        }
        flattenedPom.setModelEncoding(modelEncoding);
        try {
            cleanPom = this.createCleanPom(effectivePom);
        }
        catch (Exception e) {
            throw new MojoExecutionException("failed to create a clean pom", e);
        }
        FlattenDescriptor descriptor = this.getFlattenDescriptor();
        Model originalPom = this.getOriginalModel();
        Model resolvedPom = this.project.getModel();
        Model interpolatedPom = this.createResolvedPom(buildingRequest);
        for (PomProperty<?> property : PomProperty.getPomProperties()) {
            if (!property.isElement()) continue;
            Model sourceModel = this.getSourceModel(descriptor, property, effectivePom, originalPom, resolvedPom, interpolatedPom, cleanPom);
            if (sourceModel == null) {
                if (!property.isRequired()) continue;
                throw new MojoFailureException("Property " + property.getName() + " is required and can not be removed!");
            }
            property.copy(sourceModel, flattenedPom);
        }
        return flattenedPom;
    }

    private Model createResolvedPom(ModelBuildingRequest buildingRequest) throws MojoExecutionException {
        LoggingModelProblemCollector problems = new LoggingModelProblemCollector(this.getLog());
        Model originalModel = this.getOriginalModel();
        if (this.flattenMode == FlattenMode.resolveCiFriendliesOnly) {
            return this.modelCiFriendlyInterpolator.interpolateModel(originalModel, this.project.getModel().getProjectDirectory(), buildingRequest, problems);
        }
        return this.modelInterpolator.interpolateModel(originalModel, this.project.getModel().getProjectDirectory(), buildingRequest, (ModelProblemCollector)problems);
    }

    private Model getOriginalModel() throws MojoExecutionException {
        MavenXpp3Reader reader = new MavenXpp3Reader();
        try {
            return reader.read(Files.newInputStream(this.project.getFile().toPath(), new OpenOption[0]));
        }
        catch (IOException | XmlPullParserException e) {
            throw new MojoExecutionException("Error reading raw model.", (Exception)e);
        }
    }

    protected Model createCleanPom(Model effectivePom) throws MojoExecutionException {
        Model cleanPom = new Model();
        cleanPom.setGroupId(effectivePom.getGroupId());
        cleanPom.setArtifactId(effectivePom.getArtifactId());
        cleanPom.setVersion(effectivePom.getVersion());
        cleanPom.setPackaging(effectivePom.getPackaging());
        cleanPom.setLicenses(effectivePom.getLicenses());
        cleanPom.setModelVersion("4.0.0");
        Build build = effectivePom.getBuild();
        if (build != null) {
            for (Object plugin : build.getPlugins()) {
                if (!plugin.isExtensions()) continue;
                Build cleanBuild = cleanPom.getBuild();
                if (cleanBuild == null) {
                    cleanBuild = new Build();
                    cleanPom.setBuild(cleanBuild);
                }
                Plugin cleanPlugin = new Plugin();
                cleanPlugin.setGroupId(plugin.getGroupId());
                cleanPlugin.setArtifactId(plugin.getArtifactId());
                cleanPlugin.setVersion(plugin.getVersion());
                cleanPlugin.setExtensions(true);
                cleanBuild.addPlugin(cleanPlugin);
            }
        }
        Dependencies managedDependencies = new Dependencies();
        if (effectivePom.getDependencyManagement() != null && effectivePom.getDependencyManagement().getDependencies() != null) {
            managedDependencies.addAll(effectivePom.getDependencyManagement().getDependencies());
        }
        for (Profile profile : effectivePom.getProfiles()) {
            if (this.isEmbedBuildProfileDependencies() && FlattenMojo.isBuildTimeDriven(profile.getActivation()) || this.isEmpty(profile.getDependencies()) && this.isEmpty(profile.getRepositories())) continue;
            ArrayList<Dependency> strippedDependencies = new ArrayList<Dependency>();
            for (Dependency dep : profile.getDependencies()) {
                Dependency flattenedDep;
                Dependency parsedDep = dep.clone();
                if (managedDependencies.contains(parsedDep)) {
                    String managedDepOptional;
                    parsedDep.setVersion(managedDependencies.resolve(parsedDep).getVersion());
                    String managedDepScope = managedDependencies.resolve(parsedDep).getScope();
                    if (managedDepScope != null) {
                        parsedDep.setScope(managedDepScope);
                    }
                    if (parsedDep.getScope() == null) {
                        parsedDep.setScope("compile");
                    }
                    if ((managedDepOptional = managedDependencies.resolve(parsedDep).getOptional()) != null) {
                        parsedDep.setOptional(managedDepOptional);
                    }
                    if (parsedDep.getOptional() == null) {
                        parsedDep.setOptional("false");
                    }
                }
                if ((flattenedDep = this.createFlattenedDependency(parsedDep)) == null) continue;
                strippedDependencies.add(flattenedDep);
            }
            if (strippedDependencies.isEmpty() && this.isEmpty(profile.getRepositories())) continue;
            Profile strippedProfile = new Profile();
            strippedProfile.setId(profile.getId());
            strippedProfile.setActivation(profile.getActivation());
            strippedProfile.setDependencies(strippedDependencies.isEmpty() ? null : strippedDependencies);
            strippedProfile.setRepositories(profile.getRepositories());
            cleanPom.addProfile(strippedProfile);
        }
        List<Dependency> dependencies = this.createFlattenedDependencies(effectivePom);
        cleanPom.setDependencies(dependencies);
        return cleanPom;
    }

    private Model getSourceModel(FlattenDescriptor descriptor, PomProperty<?> property, Model effectivePom, Model originalPom, Model resolvedPom, Model interpolatedPom, Model cleanPom) {
        ElementHandling handling = descriptor.getHandling(property);
        this.getLog().debug((CharSequence)("Property " + property.getName() + " will be handled using " + (Object)((Object)handling) + " in flattened POM."));
        switch (handling) {
            case expand: {
                return effectivePom;
            }
            case keep: {
                return originalPom;
            }
            case resolve: {
                return resolvedPom;
            }
            case interpolate: {
                return interpolatedPom;
            }
            case flatten: {
                return cleanPom;
            }
            case remove: {
                return null;
            }
        }
        throw new IllegalStateException(handling.toString());
    }

    protected static List<Repository> createFlattenedRepositories(List<Repository> repositories) {
        if (repositories != null) {
            ArrayList<Repository> flattenedRepositories = new ArrayList<Repository>(repositories.size());
            for (Repository repo : repositories) {
                if (FlattenMojo.isCentralRepositoryFromSuperPom(repo)) continue;
                flattenedRepositories.add(repo);
            }
            return flattenedRepositories;
        }
        return repositories;
    }

    private FlattenDescriptor getFlattenDescriptor() throws MojoFailureException {
        FlattenDescriptor descriptor = this.pomElements;
        if (descriptor == null) {
            FlattenMode mode = this.flattenMode;
            if (mode == null) {
                mode = FlattenMode.defaults;
            } else if (this.flattenMode == FlattenMode.minimum) {
                this.getLog().warn((CharSequence)("FlattenMode " + (Object)((Object)FlattenMode.minimum) + " is deprecated!"));
            }
            descriptor = mode.getDescriptor();
            if ("maven-plugin".equals(this.project.getPackaging())) {
                descriptor.setPrerequisites(ElementHandling.expand);
            }
        } else {
            if (descriptor.isEmpty()) {
                Xpp3Dom rawDescriptor = this.mojoExecution.getConfiguration().getChild("pomElements");
                descriptor = new FlattenDescriptor(rawDescriptor);
            }
            if (this.flattenMode != null) {
                descriptor = descriptor.merge(this.flattenMode.getDescriptor());
            }
        }
        return descriptor;
    }

    private static boolean isCentralRepositoryFromSuperPom(Repository repo) {
        if (repo != null && "central".equals(repo.getId())) {
            RepositoryPolicy snapshots = repo.getSnapshots();
            return snapshots != null && !snapshots.isEnabled();
        }
        return false;
    }

    private ModelBuildingRequest createModelBuildingRequest(File pomFile) {
        RequestTrace trace = new RequestTrace((Object)pomFile);
        String context = this.mojoExecution.getExecutionId();
        FlattenModelResolver resolver = new FlattenModelResolver(this.session.getRepositorySession(), this.repositorySystem, trace, context, this.project.getRemoteProjectRepositories(), this.getReactorModelsFromSession());
        Properties userProperties = this.session.getUserProperties();
        List activeProfiles = this.session.getRequest().getActiveProfiles();
        return new DefaultModelBuildingRequest().setUserProperties(userProperties).setSystemProperties(System.getProperties()).setPomFile(pomFile).setModelResolver((ModelResolver)resolver).setActiveProfileIds(activeProfiles);
    }

    private List<MavenProject> getReactorModelsFromSession() {
        List<MavenProject> models = this.session.getAllProjects();
        if (models == null) {
            models = this.session.getProjects();
        }
        if (models == null) {
            models = Collections.emptyList();
        }
        return models;
    }

    protected Model createEffectivePom(ModelBuildingRequest buildingRequest, boolean embedBuildProfileDependencies, FlattenMode flattenMode) throws MojoExecutionException {
        ModelBuildingResult buildingResult;
        try {
            ProfileInjector customInjector = (model, profile, request, problems) -> {
                Properties merged = new Properties();
                merged.putAll((Map<?, ?>)model.getProperties());
                merged.putAll((Map<?, ?>)profile.getProperties());
                model.setProperties(merged);
                DependencyManagement profileDependencyManagement = profile.getDependencyManagement();
                if (profileDependencyManagement != null) {
                    List src;
                    DependencyManagement modelDependencyManagement = model.getDependencyManagement();
                    if (modelDependencyManagement == null) {
                        modelDependencyManagement = new DependencyManagement();
                        model.setDependencyManagement(modelDependencyManagement);
                    }
                    if (!(src = profileDependencyManagement.getDependencies()).isEmpty()) {
                        List tgt = modelDependencyManagement.getDependencies();
                        LinkedHashMap<String, Dependency> mergedDependencies = new LinkedHashMap<String, Dependency>((src.size() + tgt.size()) * 2);
                        for (Dependency element : tgt) {
                            mergedDependencies.put(element.getManagementKey(), element);
                        }
                        for (Dependency element : src) {
                            String key = element.getManagementKey();
                            if (mergedDependencies.containsKey(key)) continue;
                            mergedDependencies.put(key, element);
                        }
                        modelDependencyManagement.setDependencies(new ArrayList(mergedDependencies.values()));
                    }
                }
            };
            buildingResult = this.modelBuilderThreadSafetyWorkaround.build(buildingRequest, customInjector, (ProfileSelector)new DefaultProfileSelector());
        }
        catch (ModelBuildingException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)((Object)e));
        }
        Model effectivePom = buildingResult.getEffectiveModel();
        effectivePom.setRepositories(FlattenMojo.createFlattenedRepositories(effectivePom.getRepositories()));
        return effectivePom;
    }

    private boolean isEmpty(Collection<?> collection) {
        if (collection == null) {
            return true;
        }
        return collection.isEmpty();
    }

    public boolean isEmbedBuildProfileDependencies() {
        return this.embedBuildProfileDependencies;
    }

    protected static boolean isBuildTimeDriven(Activation activation) {
        if (activation == null) {
            return true;
        }
        return StringUtils.isEmpty((String)activation.getJdk()) && activation.getOs() == null;
    }

    protected List<Dependency> createFlattenedDependencies(Model effectiveModel) throws MojoExecutionException {
        ArrayList<Dependency> flattenedDependencies = new ArrayList<Dependency>();
        try {
            this.createFlattenedDependencies(effectiveModel, flattenedDependencies);
        }
        catch (Exception e) {
            throw new MojoExecutionException("unable to create flattened dependencies", e);
        }
        if (this.isEmbedBuildProfileDependencies()) {
            Model projectModel = this.project.getModel();
            Dependencies modelDependencies = new Dependencies();
            modelDependencies.addAll(projectModel.getDependencies());
            for (Profile profile : projectModel.getProfiles()) {
                if (!FlattenMojo.isBuildTimeDriven(profile.getActivation())) continue;
                List profileDependencies = profile.getDependencies();
                for (Dependency profileDependency : profileDependencies) {
                    if (!modelDependencies.contains(profileDependency)) continue;
                    Dependency resolvedProfileDependency = modelDependencies.resolve(profileDependency);
                    if (this.omitExclusions) {
                        resolvedProfileDependency.setExclusions(Collections.emptyList());
                    }
                    flattenedDependencies.add(resolvedProfileDependency);
                }
            }
            this.getLog().debug((CharSequence)("Resolved " + flattenedDependencies.size() + " dependency/-ies for flattened POM."));
        }
        return flattenedDependencies;
    }

    private void createFlattenedDependenciesDirect(List<Dependency> projectDependencies, List<Dependency> flattenedDependencies) {
        for (Dependency projectDependency : projectDependencies) {
            Dependency flattenedDependency = this.createFlattenedDependency(projectDependency);
            if (flattenedDependency == null) continue;
            flattenedDependencies.add(flattenedDependency);
        }
    }

    private void createFlattenedDependenciesAll(List<Dependency> projectDependencies, List<Dependency> managedDependencies, List<Dependency> flattenedDependencies) throws ArtifactDescriptorException, DependencyCollectionException {
        final LinkedList dependencyNodeLinkedList = new LinkedList();
        HashSet<String> processedDependencies = new HashSet<String>();
        Artifact projectArtifact = this.project.getArtifact();
        CollectRequest collectRequest = new CollectRequest();
        collectRequest.setRepositories(this.project.getRemoteProjectRepositories());
        collectRequest.setRootArtifact(RepositoryUtils.toArtifact((Artifact)projectArtifact));
        for (Dependency dependency : projectDependencies) {
            collectRequest.addDependency(RepositoryUtils.toDependency((Dependency)dependency, (ArtifactTypeRegistry)this.session.getRepositorySession().getArtifactTypeRegistry()));
        }
        for (Artifact artifact : this.project.getArtifacts()) {
            collectRequest.addDependency(RepositoryUtils.toDependency((Artifact)artifact, null));
        }
        for (Dependency dependency : managedDependencies) {
            collectRequest.addManagedDependency(RepositoryUtils.toDependency((Dependency)dependency, (ArtifactTypeRegistry)this.session.getRepositorySession().getArtifactTypeRegistry()));
        }
        DefaultRepositorySystemSession derived = new DefaultRepositorySystemSession(this.session.getRepositorySession());
        derived.setConfigProperty("aether.conflictResolver.verbose", (Object)true);
        derived.setConfigProperty("aether.dependencyManager.verbose", (Object)true);
        CollectResult collectResult = this.repositorySystem.collectDependencies((RepositorySystemSession)derived, collectRequest);
        final DependencyNode root = collectResult.getRoot();
        final Set directDependencyKeys = Stream.concat(projectDependencies.stream().map(this::getKey), this.project.getArtifacts().stream().map(this::getKey)).collect(Collectors.toSet());
        root.accept(new DependencyVisitor(){

            public boolean visitEnter(DependencyNode node) {
                String dependencyKey;
                if (root == node) {
                    return true;
                }
                if ("provided".equals(node.getDependency().getScope()) && !directDependencyKeys.contains(dependencyKey = FlattenMojo.this.getKey(node.getDependency()))) {
                    return false;
                }
                if (node.getDependency().isOptional()) {
                    return false;
                }
                dependencyNodeLinkedList.add(node);
                return true;
            }

            public boolean visitLeave(DependencyNode node) {
                return true;
            }
        });
        while (!dependencyNodeLinkedList.isEmpty()) {
            Dependency flattenedDependency;
            String dependencyString;
            DependencyNode node = (DependencyNode)dependencyNodeLinkedList.poll();
            org.eclipse.aether.graph.Dependency d = node.getDependency();
            Artifact artifact = RepositoryUtils.toArtifact((org.eclipse.aether.artifact.Artifact)node.getArtifact());
            Dependency dependency = new Dependency();
            dependency.setGroupId(artifact.getGroupId());
            dependency.setArtifactId(artifact.getArtifactId());
            dependency.setVersion(artifact.getBaseVersion());
            dependency.setClassifier(artifact.getClassifier());
            dependency.setOptional(d.isOptional());
            dependency.setScope(d.getScope());
            dependency.setType(artifact.getType());
            if (!this.omitExclusions) {
                LinkedList<Exclusion> exclusions = new LinkedList<Exclusion>();
                DefaultArtifact aetherArtifact = new DefaultArtifact(artifact.getGroupId(), artifact.getArtifactId(), null, artifact.getVersion());
                ArtifactDescriptorRequest request = new ArtifactDescriptorRequest((org.eclipse.aether.artifact.Artifact)aetherArtifact, null, null);
                ArtifactDescriptorResult artifactDescriptorResult = this.repositorySystem.readArtifactDescriptor(this.session.getRepositorySession(), request);
                for (org.eclipse.aether.graph.Dependency artifactDependency : artifactDescriptorResult.getDependencies()) {
                    if ("test".equals(artifactDependency.getScope())) continue;
                    Exclusion exclusion = new Exclusion();
                    exclusion.setGroupId(artifactDependency.getArtifact().getGroupId());
                    exclusion.setArtifactId(artifactDependency.getArtifact().getArtifactId());
                    exclusions.add(exclusion);
                }
                dependency.setExclusions(exclusions);
            }
            if (!processedDependencies.add(dependencyString = dependency.getManagementKey()) || (flattenedDependency = this.createFlattenedDependency(dependency)) == null) continue;
            flattenedDependencies.add(flattenedDependency);
        }
    }

    private String getKey(Artifact a) {
        String ext = this.artifactHandlerManager.getArtifactHandler(a.getType()).getExtension();
        return a.getGroupId() + ":" + a.getArtifactId() + ":" + ext + (a.getClassifier() != null ? ":" + a.getClassifier() : "");
    }

    private String getKey(Dependency d) {
        String ext = this.artifactHandlerManager.getArtifactHandler(d.getType()).getExtension();
        return d.getGroupId() + ":" + d.getArtifactId() + ":" + ext + (d.getClassifier() != null ? ":" + d.getClassifier() : "");
    }

    private String getKey(org.eclipse.aether.graph.Dependency dependency) {
        org.eclipse.aether.artifact.Artifact a = dependency.getArtifact();
        return a.getGroupId() + ":" + a.getArtifactId() + ":" + a.getExtension() + (!a.getClassifier().isEmpty() ? ":" + a.getClassifier() : "");
    }

    protected void createFlattenedDependencies(Model effectiveModel, List<Dependency> flattenedDependencies) throws MojoExecutionException {
        this.getLog().debug((CharSequence)("Resolving dependencies of " + effectiveModel.getId()));
        List projectDependencies = effectiveModel.getDependencies();
        if (this.flattenDependencyMode == null | this.flattenDependencyMode == FlattenDependencyMode.direct) {
            this.createFlattenedDependenciesDirect(projectDependencies, flattenedDependencies);
        } else if (this.flattenDependencyMode == FlattenDependencyMode.all) {
            try {
                this.createFlattenedDependenciesAll(projectDependencies, effectiveModel.getDependencyManagement() != null ? effectiveModel.getDependencyManagement().getDependencies() : Collections.emptyList(), flattenedDependencies);
            }
            catch (Exception e) {
                throw new MojoExecutionException("caught exception when flattening dependencies", e);
            }
        }
    }

    protected Dependency createFlattenedDependency(Dependency projectDependency) {
        if ("test".equals(projectDependency.getScope())) {
            return null;
        }
        if (this.omitExclusions) {
            projectDependency.setExclusions(Collections.emptyList());
        }
        return projectDependency;
    }

    public boolean isUpdatePomFile() {
        if (this.updatePomFile == null) {
            if (this.flattenMode == FlattenMode.bom) {
                return true;
            }
            return !this.project.getPackaging().equals("pom");
        }
        return this.updatePomFile;
    }

    private class SaxHeaderCommentHandler
    extends DefaultHandler2 {
        private boolean rootTagSeen = false;
        private String headerComment;

        SaxHeaderCommentHandler() {
        }

        public String getHeaderComment() {
            return this.headerComment;
        }

        @Override
        public void comment(char[] ch, int start, int length) throws SAXException {
            if (!this.rootTagSeen) {
                if (this.headerComment == null) {
                    this.headerComment = new String(ch, start, length);
                } else {
                    FlattenMojo.this.getLog().warn((CharSequence)"Ignoring multiple XML header comment!");
                }
            }
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
            this.rootTagSeen = true;
        }
    }
}

