/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.javacc;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import org.codehaus.mojo.javacc.ToolFacade;
import org.codehaus.plexus.util.StringUtils;
import org.javacc.parser.Main;

class JavaCC
extends ToolFacade {
    private File inputFile;
    private File outputDirectory;
    private String grammarEncoding;
    private String jdkVersion;
    private Boolean isStatic;
    private Integer lookAhead;
    private Integer choiceAmbiguityCheck;
    private Integer otherAmbiguityCheck;
    private Boolean debugParser;
    private Boolean debugLookAhead;
    private Boolean debugTokenManager;
    private Boolean errorReporting;
    private Boolean javaUnicodeEscape;
    private Boolean unicodeInput;
    private Boolean ignoreCase;
    private Boolean commonTokenAction;
    private Boolean userTokenManager;
    private Boolean userCharStream;
    private Boolean buildParser;
    private Boolean buildTokenManager;
    private Boolean tokenManagerUsesParser;
    private String tokenExtends;
    private String tokenFactory;
    private Boolean sanityCheck;
    private Boolean forceLaCheck;
    private Boolean cacheTokens;
    private Boolean keepLineColumn;
    private Boolean supportClassVisibilityPublic;

    JavaCC() {
    }

    public void setInputFile(File value) {
        if (value != null && !value.isAbsolute()) {
            throw new IllegalArgumentException("path is not absolute: " + value);
        }
        this.inputFile = value;
    }

    public void setOutputDirectory(File value) {
        if (value != null && !value.isAbsolute()) {
            throw new IllegalArgumentException("path is not absolute: " + value);
        }
        this.outputDirectory = value;
    }

    public void setGrammarEncoding(String value) {
        this.grammarEncoding = value;
    }

    public void setJdkVersion(String value) {
        this.jdkVersion = value;
    }

    public void setStatic(Boolean value) {
        this.isStatic = value;
    }

    public void setLookAhead(Integer value) {
        this.lookAhead = value;
    }

    public void setChoiceAmbiguityCheck(Integer value) {
        this.choiceAmbiguityCheck = value;
    }

    public void setOtherAmbiguityCheck(Integer value) {
        this.otherAmbiguityCheck = value;
    }

    public void setDebugParser(Boolean value) {
        this.debugParser = value;
    }

    public void setDebugLookAhead(Boolean value) {
        this.debugLookAhead = value;
    }

    public void setDebugTokenManager(Boolean value) {
        this.debugTokenManager = value;
    }

    public void setErrorReporting(Boolean value) {
        this.errorReporting = value;
    }

    public void setJavaUnicodeEscape(Boolean value) {
        this.javaUnicodeEscape = value;
    }

    public void setUnicodeInput(Boolean value) {
        this.unicodeInput = value;
    }

    public void setIgnoreCase(Boolean value) {
        this.ignoreCase = value;
    }

    public void setCommonTokenAction(Boolean value) {
        this.commonTokenAction = value;
    }

    public void setUserTokenManager(Boolean value) {
        this.userTokenManager = value;
    }

    public void setUserCharStream(Boolean value) {
        this.userCharStream = value;
    }

    public void setBuildParser(Boolean value) {
        this.buildParser = value;
    }

    public void setBuildTokenManager(Boolean value) {
        this.buildTokenManager = value;
    }

    public void setTokenManagerUsesParser(Boolean value) {
        this.tokenManagerUsesParser = value;
    }

    public void setTokenExtends(String value) {
        this.tokenExtends = value;
    }

    public void setTokenFactory(String value) {
        this.tokenFactory = value;
    }

    public void setSanityCheck(Boolean value) {
        this.sanityCheck = value;
    }

    public void setForceLaCheck(Boolean value) {
        this.forceLaCheck = value;
    }

    public void setCacheTokens(Boolean value) {
        this.cacheTokens = value;
    }

    public void setKeepLineColumn(Boolean value) {
        this.keepLineColumn = value;
    }

    public void setSupportClassVisibilityPublic(Boolean value) {
        this.supportClassVisibilityPublic = value;
    }

    protected int execute() throws Exception {
        String[] args = this.generateArguments();
        if (this.outputDirectory != null && !this.outputDirectory.exists()) {
            this.outputDirectory.mkdirs();
        }
        return Main.mainProgram((String[])args);
    }

    private String[] generateArguments() {
        ArrayList<String> argsList = new ArrayList<String>();
        if (StringUtils.isNotEmpty((String)this.grammarEncoding)) {
            argsList.add("-GRAMMAR_ENCODING=" + this.grammarEncoding);
        }
        if (StringUtils.isNotEmpty((String)this.jdkVersion)) {
            argsList.add("-JDK_VERSION=" + this.jdkVersion);
        }
        if (this.lookAhead != null) {
            argsList.add("-LOOKAHEAD=" + this.lookAhead);
        }
        if (this.choiceAmbiguityCheck != null) {
            argsList.add("-CHOICE_AMBIGUITY_CHECK=" + this.choiceAmbiguityCheck);
        }
        if (this.otherAmbiguityCheck != null) {
            argsList.add("-OTHER_AMBIGUITY_CHECK=" + this.otherAmbiguityCheck);
        }
        if (this.isStatic != null) {
            argsList.add("-STATIC=" + this.isStatic);
        }
        if (this.debugParser != null) {
            argsList.add("-DEBUG_PARSER=" + this.debugParser);
        }
        if (this.debugLookAhead != null) {
            argsList.add("-DEBUG_LOOKAHEAD=" + this.debugLookAhead);
        }
        if (this.debugTokenManager != null) {
            argsList.add("-DEBUG_TOKEN_MANAGER=" + this.debugTokenManager);
        }
        if (this.errorReporting != null) {
            argsList.add("-ERROR_REPORTING=" + this.errorReporting);
        }
        if (this.javaUnicodeEscape != null) {
            argsList.add("-JAVA_UNICODE_ESCAPE=" + this.javaUnicodeEscape);
        }
        if (this.unicodeInput != null) {
            argsList.add("-UNICODE_INPUT=" + this.unicodeInput);
        }
        if (this.ignoreCase != null) {
            argsList.add("-IGNORE_CASE=" + this.ignoreCase);
        }
        if (this.commonTokenAction != null) {
            argsList.add("-COMMON_TOKEN_ACTION=" + this.commonTokenAction);
        }
        if (this.userTokenManager != null) {
            argsList.add("-USER_TOKEN_MANAGER=" + this.userTokenManager);
        }
        if (this.userCharStream != null) {
            argsList.add("-USER_CHAR_STREAM=" + this.userCharStream);
        }
        if (this.buildParser != null) {
            argsList.add("-BUILD_PARSER=" + this.buildParser);
        }
        if (this.buildTokenManager != null) {
            argsList.add("-BUILD_TOKEN_MANAGER=" + this.buildTokenManager);
        }
        if (this.tokenManagerUsesParser != null) {
            argsList.add("-TOKEN_MANAGER_USES_PARSER=" + this.tokenManagerUsesParser);
        }
        if (StringUtils.isNotEmpty((String)this.tokenExtends)) {
            argsList.add("-TOKEN_EXTENDS=" + this.tokenExtends);
        }
        if (StringUtils.isNotEmpty((String)this.tokenFactory)) {
            argsList.add("-TOKEN_FACTORY=" + this.tokenFactory);
        }
        if (this.sanityCheck != null) {
            argsList.add("-SANITY_CHECK=" + this.sanityCheck);
        }
        if (this.forceLaCheck != null) {
            argsList.add("-FORCE_LA_CHECK=" + this.forceLaCheck);
        }
        if (this.cacheTokens != null) {
            argsList.add("-CACHE_TOKENS=" + this.cacheTokens);
        }
        if (this.keepLineColumn != null) {
            argsList.add("-KEEP_LINE_COLUMN=" + this.keepLineColumn);
        }
        if (this.supportClassVisibilityPublic != null) {
            argsList.add("-SUPPORT_CLASS_VISIBILITY_PUBLIC=" + this.supportClassVisibilityPublic);
        }
        if (this.outputDirectory != null) {
            argsList.add("-OUTPUT_DIRECTORY=" + this.outputDirectory.getAbsolutePath());
        }
        if (this.inputFile != null) {
            argsList.add(this.inputFile.getAbsolutePath());
        }
        return argsList.toArray(new String[argsList.size()]);
    }

    public String toString() {
        return Arrays.asList(this.generateArguments()).toString();
    }
}

