/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.jaxb2.javageneration;

import com.sun.tools.xjc.XJCListener;
import org.apache.maven.plugin.logging.Log;
import org.codehaus.mojo.jaxb2.shared.Validate;
import org.xml.sax.SAXParseException;

public class XjcLogAdapter
extends XJCListener {
    private Log log;

    public XjcLogAdapter(Log log) {
        Validate.notNull(log, "log");
        this.log = log;
    }

    public void generatedFile(String fileName, int current, int total) {
        if (this.log.isDebugEnabled()) {
            this.log.debug((CharSequence)("Processing file [" + current + "/" + total + "]: " + fileName));
        }
    }

    public void error(SAXParseException exception) {
        this.log.error((CharSequence)this.getLocation(exception), (Throwable)exception);
    }

    public void fatalError(SAXParseException exception) {
        this.log.error((CharSequence)this.getLocation(exception), (Throwable)exception);
    }

    public void warning(SAXParseException exception) {
        this.log.warn((CharSequence)this.getLocation(exception), (Throwable)exception);
    }

    public void info(SAXParseException exception) {
        this.log.info((CharSequence)this.getLocation(exception), (Throwable)exception);
    }

    private String getLocation(SAXParseException e) {
        String exceptionId = e.getPublicId() == null ? e.getSystemId() : e.getPublicId();
        return exceptionId + " [" + e.getLineNumber() + "," + e.getColumnNumber() + "] ";
    }
}

