/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.license;

import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.ArtifactNotFoundException;
import org.apache.maven.artifact.resolver.ArtifactResolutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.ProjectBuildingException;
import org.codehaus.mojo.license.AbstractLicenseMojo;
import org.codehaus.mojo.license.api.DefaultThirdPartyHelper;
import org.codehaus.mojo.license.api.DependenciesTool;
import org.codehaus.mojo.license.api.ThirdPartyHelper;
import org.codehaus.mojo.license.api.ThirdPartyTool;
import org.codehaus.mojo.license.api.ThirdPartyToolException;
import org.codehaus.mojo.license.model.LicenseMap;
import org.codehaus.mojo.license.utils.FileUtil;
import org.codehaus.mojo.license.utils.MojoHelper;
import org.codehaus.mojo.license.utils.SortedProperties;
import org.codehaus.mojo.license.utils.StringToList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractAddThirdPartyMojo
extends AbstractLicenseMojo {
    @Parameter(property="license.outputDirectory", defaultValue="${project.build.directory}/generated-sources/license", required=true)
    private File outputDirectory;
    @Parameter(property="license.deployMissingFile", defaultValue="true")
    boolean deployMissingFile;
    @Parameter(property="license.useRepositoryMissingFiles", defaultValue="true")
    boolean useRepositoryMissingFiles;
    @Parameter(property="license.acceptPomPackaging", defaultValue="false")
    boolean acceptPomPackaging;
    @Parameter(property="license.excludedScopes", defaultValue="system")
    String excludedScopes;
    @Parameter(property="license.includedScopes")
    String includedScopes;
    @Parameter(property="license.excludedGroups")
    String excludedGroups;
    @Parameter(property="license.includedGroups")
    String includedGroups;
    @Parameter(property="license.excludedArtifacts")
    String excludedArtifacts;
    @Parameter(property="license.includedArtifacts")
    String includedArtifacts;
    @Parameter(property="license.includeTransitiveDependencies", defaultValue="true")
    boolean includeTransitiveDependencies;
    @Parameter(property="license.excludeTransitiveDependencies", defaultValue="false")
    boolean excludeTransitiveDependencies;
    @Parameter(property="license.thirdPartyFilename", defaultValue="THIRD-PARTY.txt", required=true)
    String thirdPartyFilename;
    @Parameter(property="license.useMissingFile", defaultValue="false")
    boolean useMissingFile;
    @Parameter(property="license.missingFile", defaultValue="src/license/THIRD-PARTY.properties")
    File missingFile;
    @Parameter(property="license.missingLicensesFileArtifact")
    String missingLicensesFileArtifact;
    @Parameter(property="license.overrideFile", defaultValue="src/license/override-THIRD-PARTY.properties")
    File overrideFile;
    @Parameter
    List<String> licenseMerges;
    @Parameter(property="license.includedLicenses")
    IncludedLicenses includedLicenses;
    @Parameter(property="license.excludedLicenses")
    ExcludedLicenses excludedLicenses;
    @Parameter(property="license.bundleThirdPartyPath", defaultValue="META-INF/${project.artifactId}-THIRD-PARTY.txt")
    String bundleThirdPartyPath;
    @Parameter(property="license.generateBundle", defaultValue="false")
    boolean generateBundle;
    @Parameter(property="license.force", defaultValue="false")
    boolean force;
    @Deprecated
    @Parameter(property="license.failIfWarning", defaultValue="false")
    boolean failIfWarning;
    @Parameter(property="license.failOnMissing", defaultValue="false")
    boolean failOnMissing;
    @Parameter(property="license.failOnBlacklist", defaultValue="false")
    boolean failOnBlacklist;
    @Parameter(property="license.sortArtifactByName", defaultValue="false")
    boolean sortArtifactByName;
    @Parameter(property="license.fileTemplate", defaultValue="/org/codehaus/mojo/license/third-party-file.ftl")
    String fileTemplate;
    @Parameter(property="localRepository", required=true, readonly=true)
    ArtifactRepository localRepository;
    @Parameter(property="project.remoteArtifactRepositories", required=true, readonly=true)
    List<ArtifactRepository> remoteRepositories;
    @Parameter(property="project.artifacts", required=true, readonly=true)
    Set<Artifact> dependencies;
    @Component
    private ThirdPartyTool thirdPartyTool;
    @Component
    DependenciesTool dependenciesTool;
    private ThirdPartyHelper helper;
    private SortedMap<String, MavenProject> projectDependencies;
    LicenseMap licenseMap;
    SortedSet<MavenProject> unsafeDependencies;
    private File thirdPartyFile;
    SortedProperties unsafeMappings;
    private boolean doGenerate;
    private boolean doGenerateBundle;
    private Map<String, String> globalKnownLicenses;

    protected abstract SortedMap<String, MavenProject> loadDependencies();

    protected abstract SortedProperties createUnsafeMapping() throws ProjectBuildingException, IOException, ThirdPartyToolException;

    @Override
    protected void init() throws Exception {
        Log log = this.getLog();
        if (log.isDebugEnabled()) {
            this.setVerbose(true);
        }
        this.thirdPartyFile = new File(this.getOutputDirectory(), this.thirdPartyFilename);
        long buildTimestamp = this.getBuildTimestamp();
        if (this.isVerbose() || this.getLog().isDebugEnabled()) {
            log.debug((CharSequence)("Build start   at : " + buildTimestamp));
            log.debug((CharSequence)("third-party file : " + this.thirdPartyFile.lastModified()));
        }
        boolean bl = this.doGenerate = this.isForce() || !this.thirdPartyFile.exists() || buildTimestamp > this.thirdPartyFile.lastModified();
        if (this.generateBundle) {
            File bundleFile = FileUtil.getFile(this.getOutputDirectory(), this.bundleThirdPartyPath);
            if (this.isVerbose() || this.getLog().isDebugEnabled()) {
                log.debug((CharSequence)("bundle third-party file : " + bundleFile.lastModified()));
            }
            this.doGenerateBundle = this.isForce() || !bundleFile.exists() || buildTimestamp > bundleFile.lastModified();
        } else {
            this.doGenerateBundle = false;
        }
        this.projectDependencies = this.loadDependencies();
        this.licenseMap = this.getHelper().createLicenseMap(this.projectDependencies);
    }

    void consolidate() throws IOException, ArtifactNotFoundException, ArtifactResolutionException, MojoFailureException, ProjectBuildingException, ThirdPartyToolException {
        this.unsafeDependencies = this.getHelper().getProjectsWithNoLicense(this.licenseMap);
        if (!CollectionUtils.isEmpty(this.unsafeDependencies) && this.isUseMissingFile() && this.isDoGenerate()) {
            this.unsafeMappings = this.createUnsafeMapping();
        }
        this.getHelper().mergeLicenses(this.licenseMerges, this.licenseMap);
        if (this.checkUnsafeDependencies()) {
            this.resolveUnsafeDependenciesFromFile(this.missingFile);
        }
        if (!StringUtils.isBlank((CharSequence)this.missingLicensesFileArtifact) && this.checkUnsafeDependencies()) {
            String[] tokens = StringUtils.split((String)this.missingLicensesFileArtifact, (String)":");
            if (tokens.length != 3) {
                throw new MojoFailureException("Invalid missing licenses artifact, you must specify groupId:artifactId:version " + this.missingLicensesFileArtifact);
            }
            String groupId = tokens[0];
            String artifactId = tokens[1];
            String version = tokens[2];
            this.resolveUnsafeDependenciesFromArtifact(groupId, artifactId, version);
        }
        this.overrideLicenses();
    }

    File getOutputDirectory() {
        return this.outputDirectory;
    }

    public boolean isFailIfWarning() {
        return this.failIfWarning;
    }

    SortedMap<String, MavenProject> getProjectDependencies() {
        return this.projectDependencies;
    }

    SortedSet<MavenProject> getUnsafeDependencies() {
        return this.unsafeDependencies;
    }

    public LicenseMap getLicenseMap() {
        return this.licenseMap;
    }

    public boolean isUseMissingFile() {
        return this.useMissingFile;
    }

    File getMissingFile() {
        return this.missingFile;
    }

    File getOverrideFile() {
        return this.overrideFile;
    }

    SortedProperties getUnsafeMappings() {
        return this.unsafeMappings;
    }

    boolean isForce() {
        return this.force;
    }

    boolean isDoGenerate() {
        return this.doGenerate;
    }

    boolean isDoGenerateBundle() {
        return this.doGenerateBundle;
    }

    private List<String> getExcludedLicenses() {
        return this.excludedLicenses.getData();
    }

    private List<String> getIncludedLicenses() {
        return this.includedLicenses.getData();
    }

    public void setIncludedLicenses(String includedLicenses) {
        this.includedLicenses = new IncludedLicenses(includedLicenses);
    }

    public void setExcludedLicenses(String excludedLicenses) {
        this.excludedLicenses = new ExcludedLicenses(excludedLicenses);
    }

    protected ThirdPartyHelper getHelper() {
        if (this.helper == null) {
            this.helper = new DefaultThirdPartyHelper(this.getProject(), this.getEncoding(), this.isVerbose(), this.dependenciesTool, this.thirdPartyTool, this.localRepository, this.remoteRepositories, this.getLog());
        }
        return this.helper;
    }

    void resolveUnsafeDependenciesFromArtifact(String groupId, String artifactId, String version) throws ArtifactNotFoundException, IOException, ArtifactResolutionException {
        File missingLicensesFromArtifact = this.thirdPartyTool.resolveMissingLicensesDescriptor(groupId, artifactId, version, this.localRepository, this.remoteRepositories);
        this.resolveUnsafeDependenciesFromFile(missingLicensesFromArtifact);
    }

    void resolveUnsafeDependenciesFromFile(File missingLicenses) throws IOException {
        SortedSet<MavenProject> unsafeDeps = this.getUnsafeDependencies();
        if (missingLicenses != null && missingLicenses.exists() && missingLicenses.length() > 0L) {
            SortedProperties unsafeMappings = new SortedProperties(this.getEncoding());
            if (missingLicenses.exists()) {
                unsafeMappings.load(missingLicenses);
            }
            HashSet<MavenProject> resolvedDependencies = new HashSet<MavenProject>();
            for (MavenProject unsafeDependency : unsafeDeps) {
                String id = MojoHelper.getArtifactId(unsafeDependency.getArtifact());
                if (!unsafeMappings.containsKey(id) || !StringUtils.isNotBlank((CharSequence)unsafeMappings.getProperty(id))) continue;
                this.thirdPartyTool.addLicense(this.licenseMap, unsafeDependency, unsafeMappings.getProperty(id));
                resolvedDependencies.add(unsafeDependency);
            }
            unsafeDeps.removeAll(resolvedDependencies);
        }
    }

    boolean checkUnsafeDependencies() {
        boolean unsafe;
        SortedSet<MavenProject> unsafeDeps = this.getUnsafeDependencies();
        boolean bl = unsafe = !CollectionUtils.isEmpty(unsafeDeps);
        if (unsafe) {
            Log log = this.getLog();
            log.warn((CharSequence)("There is " + unsafeDeps.size() + " dependencies with no license :"));
            for (MavenProject dep : unsafeDeps) {
                log.warn((CharSequence)(" - " + MojoHelper.getArtifactId(dep.getArtifact())));
            }
        }
        return unsafe;
    }

    boolean checkForbiddenLicenses() {
        boolean safe;
        List<String> whiteLicenses = this.getIncludedLicenses();
        List<String> blackLicenses = this.getExcludedLicenses();
        HashSet<String> unsafeLicenses = new HashSet<String>();
        if (CollectionUtils.isNotEmpty(blackLicenses)) {
            Set licenses = this.getLicenseMap().keySet();
            this.getLog().info((CharSequence)("Excluded licenses (blacklist): " + blackLicenses));
            for (String excludeLicense : blackLicenses) {
                if (!licenses.contains(excludeLicense) || !CollectionUtils.isNotEmpty((Collection)((Collection)this.getLicenseMap().get(excludeLicense)))) continue;
                unsafeLicenses.add(excludeLicense);
            }
        }
        if (CollectionUtils.isNotEmpty(whiteLicenses)) {
            Set dependencyLicenses = this.getLicenseMap().keySet();
            this.getLog().info((CharSequence)("Included licenses (whitelist): " + whiteLicenses));
            block1: for (String dependencyLicense : dependencyLicenses) {
                this.getLog().debug((CharSequence)("Testing license '" + dependencyLicense + "'"));
                if (whiteLicenses.contains(dependencyLicense) || !CollectionUtils.isNotEmpty((Collection)((Collection)this.getLicenseMap().get(dependencyLicense)))) continue;
                this.getLog().debug((CharSequence)("Testing dependency license '" + dependencyLicense + "' against all other licenses"));
                for (MavenProject dependency : (SortedSet)this.getLicenseMap().get(dependencyLicense)) {
                    this.getLog().debug((CharSequence)("  testing dependency " + dependency));
                    boolean forbiddenLicenseUsed = true;
                    for (String otherLicense : dependencyLicenses) {
                        if (otherLicense.equals(dependencyLicense) || ((SortedSet)this.getLicenseMap().get(dependencyLicense)).isEmpty() || !whiteLicenses.contains(otherLicense) || !((SortedSet)this.getLicenseMap().get(otherLicense)).contains(dependency)) continue;
                        this.getLog().info((CharSequence)("License '" + dependencyLicense + "' for '" + dependency + "'is OK since it is also licensed under '" + otherLicense + "'"));
                        forbiddenLicenseUsed = false;
                        break;
                    }
                    if (!forbiddenLicenseUsed) continue;
                    unsafeLicenses.add(dependencyLicense);
                    continue block1;
                }
            }
        }
        if (!(safe = CollectionUtils.isEmpty(unsafeLicenses))) {
            Log log = this.getLog();
            log.warn((CharSequence)("There are " + unsafeLicenses.size() + " forbidden licenses used:"));
            for (String unsafeLicense : unsafeLicenses) {
                SortedSet deps = (SortedSet)this.getLicenseMap().get(unsafeLicense);
                if (deps.isEmpty()) continue;
                StringBuilder sb = new StringBuilder();
                sb.append("License ").append(unsafeLicense).append(" used by ").append(deps.size()).append(" dependencies:");
                for (MavenProject dep : deps) {
                    sb.append("\n -").append(MojoHelper.getArtifactName(dep));
                }
                log.warn((CharSequence)sb.toString());
            }
        }
        return safe;
    }

    void writeThirdPartyFile() throws IOException {
        if (this.doGenerate) {
            LicenseMap licenseMap1 = this.getLicenseMap();
            if (this.sortArtifactByName) {
                licenseMap1 = this.licenseMap.toLicenseMapOrderByName();
            }
            this.thirdPartyTool.writeThirdPartyFile(licenseMap1, this.thirdPartyFile, this.isVerbose(), this.getEncoding(), this.fileTemplate);
        }
        if (this.doGenerateBundle) {
            this.thirdPartyTool.writeBundleThirdPartyFile(this.thirdPartyFile, this.getOutputDirectory(), this.bundleThirdPartyPath);
        }
    }

    void overrideLicenses() throws IOException {
        LicenseMap licenseMap1 = this.getLicenseMap();
        this.thirdPartyTool.overrideLicenses(licenseMap1, this.projectDependencies, this.getEncoding(), this.overrideFile);
    }

    private boolean isFailOnMissing() {
        return this.failOnMissing;
    }

    private boolean isFailOnBlacklist() {
        return this.failOnBlacklist;
    }

    void checkMissing(boolean unsafe) throws MojoFailureException {
        if (unsafe && (this.isFailOnMissing() || this.isFailIfWarning())) {
            throw new MojoFailureException("There are some dependencies with no license, please fill the file " + this.getMissingFile());
        }
    }

    void checkBlacklist(boolean safeLicense) throws MojoFailureException {
        if (!safeLicense && (this.isFailOnBlacklist() || this.isFailIfWarning())) {
            throw new MojoFailureException("There are some forbidden licenses used, please check your dependencies.");
        }
    }

    public static class ExcludedLicenses
    extends StringToList {
        public ExcludedLicenses() {
        }

        ExcludedLicenses(String data) {
            super(data);
        }

        public void setExcludedLicense(String excludeLicense) {
            this.addEntryToList(excludeLicense);
        }
    }

    public static class IncludedLicenses
    extends StringToList {
        public IncludedLicenses() {
        }

        IncludedLicenses(String data) {
            super(data);
        }

        public void setIncludedLicense(String includeLicense) {
            this.addEntryToList(includeLicense);
        }
    }
}

