/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.license.utils;

import java.io.File;
import java.io.IOException;
import java.io.StringWriter;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.codehaus.mojo.license.Eol;
import org.codehaus.mojo.license.model.ProjectLicense;
import org.codehaus.mojo.license.model.ProjectLicenseInfo;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class LicenseSummaryWriter {
    public static void writeLicenseSummary(List<ProjectLicenseInfo> dependencies, File outputFile, Charset charset, Eol eol) throws ParserConfigurationException, TransformerException, IOException {
        DocumentBuilderFactory fact = DocumentBuilderFactory.newInstance();
        DocumentBuilder parser = fact.newDocumentBuilder();
        Document doc = parser.newDocument();
        Element root = doc.createElement("licenseSummary");
        doc.appendChild(root);
        Element dependenciesNode = doc.createElement("dependencies");
        root.appendChild(dependenciesNode);
        for (ProjectLicenseInfo dep : dependencies) {
            dependenciesNode.appendChild(LicenseSummaryWriter.createDependencyNode(doc, dep));
        }
        try (StringWriter sw = new StringWriter();){
            Transformer xformer = TransformerFactory.newInstance().newTransformer();
            xformer.setOutputProperty("indent", "yes");
            xformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
            xformer.transform(new DOMSource(doc), new StreamResult(sw));
            String platformEol = Eol.PLATFORM.getEolString();
            String outputString = !platformEol.equals(eol.getEolString()) ? sw.toString().replace(platformEol, eol.getEolString()) : sw.toString();
            Files.write(outputFile.toPath(), outputString.getBytes(charset), new OpenOption[0]);
        }
    }

    public static Node createDependencyNode(Document doc, ProjectLicenseInfo dep) {
        Element depNode = doc.createElement("dependency");
        Element groupIdNode = doc.createElement("groupId");
        groupIdNode.appendChild(doc.createTextNode(dep.getGroupId()));
        depNode.appendChild(groupIdNode);
        Element artifactIdNode = doc.createElement("artifactId");
        artifactIdNode.appendChild(doc.createTextNode(dep.getArtifactId()));
        depNode.appendChild(artifactIdNode);
        Element versionNode = doc.createElement("version");
        versionNode.appendChild(doc.createTextNode(dep.getVersion()));
        depNode.appendChild(versionNode);
        Element licensesNode = doc.createElement("licenses");
        if (dep.getLicenses() == null || dep.getLicenses().size() == 0) {
            licensesNode.appendChild(doc.createComment("No license information available. "));
        } else {
            for (ProjectLicense lic : dep.getLicenses()) {
                licensesNode.appendChild(LicenseSummaryWriter.createLicenseNode(doc, lic));
            }
        }
        depNode.appendChild(licensesNode);
        return depNode;
    }

    public static Node createLicenseNode(Document doc, ProjectLicense lic) {
        Element licenseNode = doc.createElement("license");
        if (lic.getName() != null) {
            Element licNameNode = doc.createElement("name");
            licNameNode.appendChild(doc.createTextNode(lic.getName()));
            licenseNode.appendChild(licNameNode);
        }
        if (lic.getUrl() != null) {
            Element licUrlNode = doc.createElement("url");
            licUrlNode.appendChild(doc.createTextNode(lic.getUrl()));
            licenseNode.appendChild(licUrlNode);
        }
        if (lic.getDistribution() != null) {
            Element licDistNode = doc.createElement("distribution");
            licDistNode.appendChild(doc.createTextNode(lic.getDistribution()));
            licenseNode.appendChild(licDistNode);
        }
        if (lic.getFile() != null) {
            Element licFileNode = doc.createElement("file");
            licFileNode.appendChild(doc.createTextNode(lic.getFile()));
            licenseNode.appendChild(licFileNode);
        }
        if (lic.getComments() != null) {
            Element licCommentsNode = doc.createElement("comments");
            licCommentsNode.appendChild(doc.createTextNode(lic.getComments()));
            licenseNode.appendChild(licCommentsNode);
        }
        return licenseNode;
    }
}

