/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.versions;

import java.util.Arrays;
import java.util.Collection;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.stream.XMLStreamException;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.metadata.ArtifactMetadataRetrievalException;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.artifact.versioning.DefaultArtifactVersion;
import org.apache.maven.model.Dependency;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.codehaus.mojo.versions.AbstractVersionsDependencyUpdaterMojo;
import org.codehaus.mojo.versions.api.ArtifactVersions;
import org.codehaus.mojo.versions.api.PomHelper;
import org.codehaus.mojo.versions.ordering.VersionComparator;
import org.codehaus.mojo.versions.rewriting.ModifiedPomXMLEventReader;

@Mojo(name="use-next-snapshots", requiresProject=true, requiresDirectInvocation=true, threadSafe=true)
public class UseNextSnapshotsMojo
extends AbstractVersionsDependencyUpdaterMojo {
    @Parameter(property="allowMajorUpdates", defaultValue="false")
    private boolean allowMajorUpdates;
    @Parameter(property="allowMinorUpdates", defaultValue="false")
    private boolean allowMinorUpdates;
    @Parameter(property="allowIncrementalUpdates", defaultValue="true")
    private boolean allowIncrementalUpdates;
    public final Pattern matchSnapshotRegex = Pattern.compile("^(.+)-((SNAPSHOT)|(\\d{8}\\.\\d{6}-\\d+))$");

    @Override
    protected void update(ModifiedPomXMLEventReader pom) throws MojoExecutionException, MojoFailureException, XMLStreamException {
        try {
            if (this.getProject().getDependencyManagement() != null && this.isProcessingDependencyManagement()) {
                this.useNextSnapshots(pom, this.getProject().getDependencyManagement().getDependencies());
            }
            if (this.getProject().getDependencies() != null && this.isProcessingDependencies()) {
                this.useNextSnapshots(pom, this.getProject().getDependencies());
            }
        }
        catch (ArtifactMetadataRetrievalException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)((Object)e));
        }
    }

    private void useNextSnapshots(ModifiedPomXMLEventReader pom, Collection<Dependency> dependencies) throws XMLStreamException, MojoExecutionException, ArtifactMetadataRetrievalException {
        int segment = this.determineUnchangedSegment(this.allowMajorUpdates, this.allowMinorUpdates, this.allowIncrementalUpdates);
        block0: for (Dependency dep : dependencies) {
            DefaultArtifactVersion lowerBound;
            if (this.isExcludeReactor() && this.isProducedByReactor(dep)) {
                this.getLog().info((CharSequence)("Ignoring reactor dependency: " + this.toString(dep)));
                continue;
            }
            if (this.isHandledByProperty(dep)) {
                this.getLog().debug((CharSequence)("Ignoring dependency with property as version: " + this.toString(dep)));
                continue;
            }
            String version = dep.getVersion();
            Matcher versionMatcher = this.matchSnapshotRegex.matcher(version);
            if (versionMatcher.matches()) continue;
            this.getLog().debug((CharSequence)("Looking for next snapshot of " + this.toString(dep)));
            Artifact artifact = this.toArtifact(dep);
            if (!this.isIncluded(artifact)) continue;
            ArtifactVersions versions = this.getHelper().lookupArtifactVersions(artifact, false);
            VersionComparator versionComparator = versions.getVersionComparator();
            if (segment + 1 > versionComparator.getSegmentCount((ArtifactVersion)(lowerBound = new DefaultArtifactVersion(version)))) {
                this.getLog().info((CharSequence)("Ignoring " + this.toString(dep) + " as the version number is too short"));
                continue;
            }
            ArtifactVersion upperBound = segment >= 0 ? versionComparator.incrementSegment((ArtifactVersion)lowerBound, segment) : null;
            this.getLog().info((CharSequence)("Upper bound: " + (upperBound == null ? "none" : upperBound.toString())));
            ArtifactVersion[] newer = versions.getVersions((ArtifactVersion)lowerBound, upperBound, true, false, false);
            this.getLog().debug((CharSequence)("Candidate versions " + Arrays.asList(newer)));
            for (ArtifactVersion artifactVersion : newer) {
                String newVersion = artifactVersion.toString();
                if (!this.matchSnapshotRegex.matcher(newVersion).matches()) continue;
                if (!PomHelper.setDependencyVersion(pom, dep.getGroupId(), dep.getArtifactId(), version, newVersion, this.getProject().getModel())) continue block0;
                this.getLog().info((CharSequence)("Updated " + this.toString(dep) + " to version " + newVersion));
                continue block0;
            }
        }
    }
}

