/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.components.io.resources;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import org.codehaus.plexus.components.io.attributes.PlexusIoResourceAttributes;
import org.codehaus.plexus.components.io.resources.PlexusIoResourceWithAttributes;

public class PlexusIoFileResource
implements PlexusIoResourceWithAttributes {
    private File file;
    private String name;
    private PlexusIoResourceAttributes attributes;

    public PlexusIoFileResource() {
    }

    public PlexusIoFileResource(File file) {
        this(file, file.getPath().replace('\\', '/'));
    }

    public PlexusIoFileResource(File file, PlexusIoResourceAttributes attrs) {
        this(file, file.getPath().replace('\\', '/'), attrs);
    }

    public PlexusIoFileResource(File file, String name) {
        this.file = file;
        this.name = name;
    }

    public PlexusIoFileResource(File file, String name, PlexusIoResourceAttributes attrs) {
        this.file = file;
        this.name = name;
        this.attributes = attrs;
    }

    public void setFile(File file) {
        this.file = file;
    }

    public File getFile() {
        return this.file;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public long getLastModified() {
        return this.file.lastModified();
    }

    public boolean isFile() {
        return this.file.isFile();
    }

    public boolean isDirectory() {
        return this.file.isDirectory();
    }

    public boolean isExisting() {
        return this.file.exists();
    }

    public long getSize() {
        if (!this.isExisting()) {
            return -1L;
        }
        long result = this.file.length();
        return result == 0L ? -1L : result;
    }

    public InputStream getContents() throws IOException {
        return new FileInputStream(this.getFile());
    }

    public URL getURL() throws IOException {
        return this.getFile().toURI().toURL();
    }

    public PlexusIoResourceAttributes getAttributes() {
        return this.attributes;
    }

    public void setAttributes(PlexusIoResourceAttributes attributes) {
        this.attributes = attributes;
    }
}

