/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.components.io.resources;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import javax.annotation.Nonnull;
import org.codehaus.plexus.components.io.attributes.Java7AttributeUtils;
import org.codehaus.plexus.components.io.attributes.Java7Reflector;
import org.codehaus.plexus.components.io.attributes.PlexusIoResourceAttributes;
import org.codehaus.plexus.components.io.resources.AbstractPlexusIoResource;
import org.codehaus.plexus.components.io.resources.PlexusIoResourceWithAttributes;
import org.codehaus.plexus.components.io.resources.PlexusIoSymlinkResource;

public class PlexusIoFileResource
extends AbstractPlexusIoResource
implements PlexusIoResourceWithAttributes {
    @Nonnull
    private final File file;
    @Nonnull
    private final PlexusIoResourceAttributes attributes;

    private PlexusIoFileResource(@Nonnull File file) {
        this(file, PlexusIoFileResource.getName(file), null);
    }

    private PlexusIoFileResource(@Nonnull File file, String name) {
        this(file, name, null);
    }

    public PlexusIoFileResource(@Nonnull File file, @Nonnull PlexusIoResourceAttributes attrs) {
        this(file, PlexusIoFileResource.getName(file), attrs);
    }

    public PlexusIoFileResource(@Nonnull File file, @Nonnull String name, @Nonnull PlexusIoResourceAttributes attrs) {
        super(name, file.lastModified(), file.length(), file.isFile(), file.isDirectory(), file.exists());
        this.file = file;
        if (attrs == null) {
            throw new IllegalArgumentException("attrs is null for file " + file.getName());
        }
        this.attributes = attrs;
    }

    private static String getName(File file) {
        return file.getPath().replace('\\', '/');
    }

    public static PlexusIoFileResource fileOnDisk(File file, String name, @Nonnull PlexusIoResourceAttributes attrs) {
        if (attrs.isSymbolicLink()) {
            return new PlexusIoSymlinkResource(file, name, attrs);
        }
        return new PlexusIoFileResource(file, name, attrs);
    }

    public static PlexusIoFileResource withName(File file, String name, @Nonnull PlexusIoResourceAttributes attrs) {
        if (attrs.isSymbolicLink()) {
            return new PlexusIoSymlinkResource(file, name, attrs);
        }
        return new PlexusIoFileResource(file, name, attrs);
    }

    public static PlexusIoFileResource existingFile(File file, @Nonnull PlexusIoResourceAttributes attrs) {
        if (attrs.isSymbolicLink()) {
            return new PlexusIoSymlinkResource(file, PlexusIoFileResource.getName(file), attrs);
        }
        return new PlexusIoFileResource(file, PlexusIoFileResource.getName(file), attrs);
    }

    @Nonnull
    public File getFile() {
        return this.file;
    }

    @Nonnull
    public InputStream getContents() throws IOException {
        return new FileInputStream(this.getFile());
    }

    @Nonnull
    public URL getURL() throws IOException {
        return this.getFile().toURI().toURL();
    }

    public long getSize() {
        return this.getFile().length();
    }

    public boolean isDirectory() {
        return this.getFile().isDirectory();
    }

    public boolean isExisting() {
        return this.getFile().exists();
    }

    public boolean isFile() {
        return this.getFile().isFile();
    }

    @Nonnull
    public PlexusIoResourceAttributes getAttributes() {
        return this.attributes;
    }

    public long getLastModified() {
        if (Java7Reflector.isAtLeastJava7()) {
            return Java7AttributeUtils.getLastModified(this.getFile());
        }
        return this.getFile().lastModified();
    }

    public boolean isSymbolicLink() {
        return this.getAttributes().isSymbolicLink();
    }
}

