/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.batch;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.sonar.api.batch.Decorator;
import org.sonar.api.batch.DecoratorContext;
import org.sonar.api.batch.DefaultFormulaContext;
import org.sonar.api.batch.DefaultFormulaData;
import org.sonar.api.batch.DependedUpon;
import org.sonar.api.batch.DependsUpon;
import org.sonar.api.measures.FormulaContext;
import org.sonar.api.measures.FormulaData;
import org.sonar.api.measures.Measure;
import org.sonar.api.measures.Metric;
import org.sonar.api.resources.Project;
import org.sonar.api.resources.Resource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class FormulaDecorator
implements Decorator {
    private Metric metric;
    private DefaultFormulaContext formulaContext;
    private Set<Decorator> executeAfterDecorators;

    public FormulaDecorator(Metric metric, Set<Decorator> executeAfterDecorators) {
        if (metric.getFormula() == null) {
            throw new IllegalArgumentException("No formula defined on metric");
        }
        this.metric = metric;
        this.formulaContext = new DefaultFormulaContext(metric);
        this.executeAfterDecorators = executeAfterDecorators;
    }

    public FormulaDecorator(Metric metric) {
        this(metric, Collections.emptySet());
    }

    public boolean shouldExecuteOnProject(Project project) {
        return true;
    }

    @DependedUpon
    public Metric generatesMetric() {
        return this.metric;
    }

    @DependsUpon
    public List<Metric> dependsUponMetrics() {
        return this.metric.getFormula().dependsUponMetrics();
    }

    @DependsUpon
    public Collection<Decorator> dependsUponDecorators() {
        return this.executeAfterDecorators;
    }

    public void decorate(Resource resource, DecoratorContext context) {
        if (context.getMeasure(this.metric) != null) {
            return;
        }
        this.formulaContext.setDecoratorContext(context);
        DefaultFormulaData data = new DefaultFormulaData(context);
        Measure measure = this.metric.getFormula().calculate((FormulaData)data, (FormulaContext)this.formulaContext);
        if (measure != null) {
            context.saveMeasure(measure);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FormulaDecorator that = (FormulaDecorator)o;
        return !(this.metric == null ? that.metric != null : !this.metric.equals((Object)that.metric));
    }

    public int hashCode() {
        return this.metric != null ? this.metric.hashCode() : 0;
    }

    public String toString() {
        return "f(" + this.metric.getKey() + ")";
    }
}

