/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.batch.bootstrap;

import com.google.common.collect.Lists;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.picocontainer.MutablePicoContainer;
import org.picocontainer.PicoContainer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.api.BatchExtension;
import org.sonar.api.Plugin;
import org.sonar.api.batch.CoverageExtension;
import org.sonar.api.batch.SupportedEnvironment;
import org.sonar.api.resources.Project;
import org.sonar.api.utils.AnnotationUtils;
import org.sonar.api.utils.SonarException;
import org.sonar.batch.bootstrap.ExtensionDownloader;
import org.sonar.batch.bootstrapper.EnvironmentInformation;
import org.sonar.core.classloaders.ClassLoadersCollection;
import org.sonar.core.plugin.AbstractPluginRepository;
import org.sonar.core.plugin.JpaPlugin;
import org.sonar.core.plugin.JpaPluginDao;
import org.sonar.core.plugin.JpaPluginFile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BatchPluginRepository
extends AbstractPluginRepository {
    private static final Logger LOG = LoggerFactory.getLogger(BatchPluginRepository.class);
    private JpaPluginDao dao;
    private ClassLoadersCollection classLoaders;
    private ExtensionDownloader extensionDownloader;
    private EnvironmentInformation environment;
    private List<JpaPlugin> register;

    public BatchPluginRepository(JpaPluginDao dao, ExtensionDownloader extensionDownloader, EnvironmentInformation environment) {
        this.dao = dao;
        this.extensionDownloader = extensionDownloader;
        this.environment = environment;
        LOG.info("Execution environment: {} {}", (Object)environment.getKey(), (Object)environment.getVersion());
    }

    BatchPluginRepository() {
    }

    private List<URL> download(JpaPlugin pluginMetadata) {
        ArrayList urls = Lists.newArrayList();
        for (JpaPluginFile pluginFile : pluginMetadata.getFiles()) {
            File file = this.extensionDownloader.downloadExtension(pluginFile);
            try {
                urls.add(file.toURI().toURL());
            }
            catch (MalformedURLException e) {
                throw new SonarException("Can not get the URL of: " + file, (Throwable)e);
            }
        }
        return urls;
    }

    public void start() {
        this.register = Lists.newArrayList();
        this.classLoaders = new ClassLoadersCollection(Thread.currentThread().getContextClassLoader());
        List jpaPlugins = this.dao.getPlugins();
        for (JpaPlugin pluginMetadata : jpaPlugins) {
            if (!StringUtils.isEmpty((String)pluginMetadata.getBasePlugin())) continue;
            String key = pluginMetadata.getKey();
            List<URL> urls = this.download(pluginMetadata);
            this.classLoaders.createClassLoader(key, urls, pluginMetadata.isUseChildFirstClassLoader() == Boolean.TRUE);
            this.register.add(pluginMetadata);
        }
        for (JpaPlugin pluginMetadata : jpaPlugins) {
            String pluginKey = pluginMetadata.getKey();
            String basePluginKey = pluginMetadata.getBasePlugin();
            if (!StringUtils.isNotEmpty((String)basePluginKey)) continue;
            if (this.classLoaders.get(basePluginKey) != null) {
                LOG.debug("Plugin {} extends {}", (Object)pluginKey, (Object)basePluginKey);
                List<URL> urls = this.download(pluginMetadata);
                this.classLoaders.extend(basePluginKey, pluginKey, urls);
                this.register.add(pluginMetadata);
                continue;
            }
            LOG.warn("Plugin {} extends nonexistent plugin {}", (Object)pluginKey, (Object)basePluginKey);
        }
        this.classLoaders.done();
    }

    public void registerPlugins(MutablePicoContainer pico) {
        for (JpaPlugin pluginMetadata : this.register) {
            try {
                Class<?> claz = this.classLoaders.get(pluginMetadata.getKey()).loadClass(pluginMetadata.getPluginClass());
                Plugin plugin = (Plugin)claz.newInstance();
                this.registerPlugin(pico, plugin, pluginMetadata.getKey());
            }
            catch (Exception e) {
                throw new SonarException("Fail to load extensions from plugin " + pluginMetadata.getKey(), (Throwable)e);
            }
        }
        this.invokeExtensionProviders(pico);
    }

    protected boolean shouldRegisterExtension(PicoContainer container, String pluginKey, Object extension) {
        boolean ok = BatchPluginRepository.isType((Object)extension, BatchExtension.class);
        if (ok && !this.isSupportsEnvironment(extension)) {
            ok = false;
            LOG.debug("The following extension is ignored: " + extension + " due to execution environment.");
        }
        if (ok && BatchPluginRepository.isType((Object)extension, CoverageExtension.class) && !(ok = this.shouldRegisterCoverageExtension(pluginKey, (Project)container.getComponent(Project.class), (Configuration)container.getComponent(Configuration.class)))) {
            LOG.debug("The following extension is ignored: " + extension + ". See the parameter " + "sonar.core.codeCoveragePlugin");
        }
        return ok;
    }

    private boolean isSupportsEnvironment(Object extension) {
        Class<?> clazz = extension instanceof Class ? (Class<?>)extension : extension.getClass();
        SupportedEnvironment env = (SupportedEnvironment)AnnotationUtils.getClassAnnotation(clazz, SupportedEnvironment.class);
        if (env == null) {
            return true;
        }
        for (String supported : env.value()) {
            if (!StringUtils.equalsIgnoreCase((String)this.environment.getKey(), (String)supported)) continue;
            return true;
        }
        return false;
    }

    boolean shouldRegisterCoverageExtension(String pluginKey, Project project, Configuration conf) {
        if (!project.getAnalysisType().isDynamic(true)) {
            return false;
        }
        if (StringUtils.equals((String)project.getLanguageKey(), (String)"java")) {
            Object[] selectedPluginKeys = conf.getStringArray("sonar.core.codeCoveragePlugin");
            if (ArrayUtils.isEmpty((Object[])selectedPluginKeys)) {
                selectedPluginKeys = new String[]{"cobertura"};
            }
            return ArrayUtils.contains((Object[])selectedPluginKeys, (Object)pluginKey);
        }
        return true;
    }
}

