/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.colorizer;

import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.io.IOUtils;
import org.sonar.channel.CodeReader;
import org.sonar.colorizer.HtmlCodeBuilder;
import org.sonar.colorizer.HtmlOptions;
import org.sonar.colorizer.HtmlRenderer;
import org.sonar.colorizer.SynhtaxHighlightingException;
import org.sonar.colorizer.Tokenizer;

public class HtmlDecorator
extends Tokenizer {
    private static final String CSS_PATH = "/sonar-colorizer.css";
    private HtmlOptions options;
    private int lineId = 1;
    private boolean checked = false;
    private boolean beginOfLine = true;
    private boolean endOfLine = false;

    public HtmlDecorator(HtmlOptions options) {
        this.options = options;
        this.lineId = options.getFirstLineId();
    }

    public String getTagBeginOfFile() {
        StringBuilder sb = new StringBuilder();
        if (this.options.isGenerateHtmlHeader()) {
            sb.append("<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Transitional//EN\" \"http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd\"><html><head><style type=\"text/css\">");
            sb.append(HtmlDecorator.getCss());
            sb.append("</style></head><body>");
        }
        sb.append("<table class=\"code\" id=\"");
        if (this.options.getTableId() != null) {
            sb.append(this.options.getTableId());
        }
        sb.append("\"><tbody>");
        return sb.toString();
    }

    public String getTagEndOfFile() {
        StringBuilder sb = new StringBuilder();
        sb.append("</pre></td></tr></tbody></table>");
        if (this.options.isGenerateHtmlHeader()) {
            sb.append("</body></html>");
        }
        return sb.toString();
    }

    public String getTagBefore() {
        StringBuilder sb = new StringBuilder();
        if (this.beginOfLine) {
            sb.append("<tr id=\"");
            sb.append(this.lineId++);
            sb.append("\"><td><pre>");
        }
        return sb.toString();
    }

    public String getTagAfter() {
        if (this.endOfLine) {
            return "</pre></td></tr>";
        }
        return "";
    }

    private boolean hasNextToken(CodeReader code) {
        if (this.checked) {
            this.checked = false;
            return false;
        }
        int lastChar = code.lastChar();
        this.beginOfLine = lastChar == -1 || lastChar == 10;
        int peek = code.peek();
        this.endOfLine = peek == 10 || peek == -1;
        this.checked = this.beginOfLine || this.endOfLine;
        return this.checked;
    }

    public boolean consume(CodeReader code, HtmlCodeBuilder codeBuilder) {
        if (this.hasNextToken(code)) {
            codeBuilder.appendWithoutTransforming(this.getTagBefore());
            codeBuilder.appendWithoutTransforming(this.getTagAfter());
            return true;
        }
        return false;
    }

    public static String getCss() {
        InputStream input = null;
        try {
            input = HtmlRenderer.class.getResourceAsStream(CSS_PATH);
            String string = IOUtils.toString((InputStream)input);
            return string;
        }
        catch (IOException e) {
            throw new SynhtaxHighlightingException("Sonar Colorizer CSS file not found: /sonar-colorizer.css", e);
        }
        finally {
            IOUtils.closeQuietly((InputStream)input);
        }
    }
}

