/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.colorizer;

import org.sonar.channel.CodeReader;
import org.sonar.channel.EndMatcher;
import org.sonar.colorizer.HtmlCodeBuilder;
import org.sonar.colorizer.Tokenizer;

public class LiteralTokenizer
extends Tokenizer {
    private final String tagBefore;
    private final String tagAfter;

    public LiteralTokenizer(String tagBefore, String tagAfter) {
        this.tagBefore = tagBefore;
        this.tagAfter = tagAfter;
    }

    public LiteralTokenizer() {
        this("", "");
    }

    public boolean consume(CodeReader code, HtmlCodeBuilder codeBuilder) {
        if (code.peek() == 39 || code.peek() == 34) {
            codeBuilder.appendWithoutTransforming(this.tagBefore);
            int firstChar = code.peek();
            code.popTo((EndMatcher)new EndCommentMatcher(firstChar, code), (Appendable)codeBuilder);
            codeBuilder.appendWithoutTransforming(this.tagAfter);
            return true;
        }
        return false;
    }

    private static class EndCommentMatcher
    implements EndMatcher {
        private final int firstChar;
        private final CodeReader code;
        private StringBuilder literalValue;

        public EndCommentMatcher(int firstChar, CodeReader code) {
            this.firstChar = firstChar;
            this.code = code;
            this.literalValue = new StringBuilder();
        }

        public boolean match(int endFlag) {
            this.literalValue.append((char)endFlag);
            return this.code.lastChar() == this.firstChar && this.evenNumberOfBackSlashBeforeDelimiter() && this.literalValue.length() > 1;
        }

        private boolean evenNumberOfBackSlashBeforeDelimiter() {
            int numberOfBackSlashChar = 0;
            for (int index = this.literalValue.length() - 3; index >= 0 && this.literalValue.charAt(index) == '\\'; --index) {
                ++numberOfBackSlashChar;
            }
            return numberOfBackSlashChar % 2 == 0;
        }
    }
}

