/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.colorizer;

import com.google.common.io.ByteStreams;
import com.google.common.io.Closeables;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import org.sonar.channel.CodeReader;
import org.sonar.colorizer.HtmlCodeBuilder;
import org.sonar.colorizer.HtmlOptions;
import org.sonar.colorizer.HtmlRenderer;
import org.sonar.colorizer.SynhtaxHighlightingException;
import org.sonar.colorizer.Tokenizer;

@Deprecated
public class HtmlDecorator
extends Tokenizer {
    private static final String CSS_PATH = "/sonar-colorizer.css";
    private HtmlOptions options;
    private int lineId;
    private static final int LF = 10;
    private static final int CR = 13;

    public HtmlDecorator(HtmlOptions options) {
        this.options = options;
        this.lineId = options.getFirstLineId();
    }

    public String getTagBeginOfFile() {
        StringBuilder sb = new StringBuilder();
        if (this.options.isGenerateHtmlHeader()) {
            sb.append("<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Transitional//EN\" \"http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd\"><html><head><style type=\"text/css\">");
            sb.append(HtmlDecorator.getCss());
            sb.append("</style></head><body>");
        }
        sb.append("<table class=\"code\" id=\"");
        if (this.options.getTableId() != null) {
            sb.append(this.options.getTableId());
        }
        sb.append("\"><tbody><tr id=\"").append(this.lineId++).append("\"><td><pre>");
        return sb.toString();
    }

    public String getTagEndOfFile() {
        StringBuilder sb = new StringBuilder();
        sb.append("</pre></td></tr></tbody></table>");
        if (this.options.isGenerateHtmlHeader()) {
            sb.append("</body></html>");
        }
        return sb.toString();
    }

    public String getTagBefore() {
        String tag = "<tr id=\"" + this.lineId + "\"><td><pre>";
        ++this.lineId;
        return tag;
    }

    public String getTagAfter() {
        return "</pre></td></tr>";
    }

    public boolean consume(CodeReader code, HtmlCodeBuilder codeBuilder) {
        int lineNumber = code.getLinePosition();
        if (code.peek() == 10 || code.peek() == 13) {
            code.pop();
            if (lineNumber != code.getLinePosition()) {
                codeBuilder.appendWithoutTransforming(this.getTagAfter());
                codeBuilder.appendWithoutTransforming(this.getTagBefore());
            }
            return true;
        }
        return false;
    }

    public static String getCss() {
        InputStream input = null;
        try {
            input = HtmlRenderer.class.getResourceAsStream(CSS_PATH);
            String string = new String(ByteStreams.toByteArray((InputStream)input));
            return string;
        }
        catch (IOException e) {
            throw new SynhtaxHighlightingException("SonarQube Colorizer CSS file not found: /sonar-colorizer.css", e);
        }
        finally {
            Closeables.closeQuietly((Closeable)input);
        }
    }
}

