/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.colorizer;

import java.util.List;
import org.sonar.channel.Channel;
import org.sonar.channel.CodeReader;
import org.sonar.colorizer.HtmlCodeBuilder;
import org.sonar.colorizer.NotThreadSafeTokenizer;

public class TokenizerDispatcher {
    private Channel<HtmlCodeBuilder>[] tokenizers;

    public TokenizerDispatcher(Channel<HtmlCodeBuilder> ... tokenizers) {
        this.tokenizers = tokenizers;
    }

    public TokenizerDispatcher(List<Channel<HtmlCodeBuilder>> tokenizersArray) {
        this.tokenizers = tokenizersArray.toArray(new Channel[tokenizersArray.size()]);
    }

    public final String colorize(String code) {
        HtmlCodeBuilder colorizedCode = new HtmlCodeBuilder();
        this.colorize(new CodeReader(code), colorizedCode);
        return colorizedCode.toString();
    }

    public final void colorize(CodeReader code, HtmlCodeBuilder colorizedCode) {
        this.cloneNotThreadSafeTokenizers();
        block0: while (code.peek() != -1) {
            for (Channel<HtmlCodeBuilder> codeTokenizer : this.tokenizers) {
                if (codeTokenizer.consume(code, (Object)colorizedCode)) continue block0;
            }
            colorizedCode.append((char)code.pop());
        }
    }

    private void cloneNotThreadSafeTokenizers() {
        for (int i = 0; i < this.tokenizers.length; ++i) {
            if (!(this.tokenizers[i] instanceof NotThreadSafeTokenizer)) continue;
            this.tokenizers[i] = ((NotThreadSafeTokenizer)this.tokenizers[i]).clone();
        }
    }
}

