/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.jpa.dao;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import org.sonar.api.database.DatabaseSession;
import org.sonar.api.database.model.AsyncMeasureSnapshot;
import org.sonar.api.database.model.MeasureModel;
import org.sonar.api.database.model.Snapshot;
import org.sonar.jpa.dao.AsyncMeasuresDao;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AsyncMeasuresService {
    private final DatabaseSession session;

    public AsyncMeasuresService(DatabaseSession session) {
        this.session = session;
    }

    public void refresh(Snapshot snapshot) {
        AsyncMeasuresDao dao = new AsyncMeasuresDao(this.session);
        Snapshot previousSnapshot = dao.getPreviousSnapshot(snapshot);
        Date datePreviousSnapshot = previousSnapshot != null ? previousSnapshot.getCreatedAt() : null;
        List<AsyncMeasureSnapshot> previousAsyncMeasureSnapshots = dao.getPreviousAsyncMeasureSnapshots(snapshot.getResourceId(), datePreviousSnapshot, snapshot.getCreatedAt());
        if (previousSnapshot != null) {
            previousAsyncMeasureSnapshots.addAll(dao.getAsyncMeasureSnapshotsFromSnapshotId(previousSnapshot.getId(), this.getMetricIds(previousAsyncMeasureSnapshots)));
        }
        for (AsyncMeasureSnapshot asyncMeasureSnapshot : this.purge(previousAsyncMeasureSnapshots)) {
            if (asyncMeasureSnapshot.getSnapshotId() == null) {
                dao.updateAsyncMeasureSnapshot(asyncMeasureSnapshot, snapshot);
                continue;
            }
            dao.createAsyncMeasureSnapshot(asyncMeasureSnapshot.getMeasureId(), snapshot.getId(), asyncMeasureSnapshot.getMeasureDate(), snapshot.getCreatedAt(), asyncMeasureSnapshot.getMetricId(), asyncMeasureSnapshot.getProjectId());
        }
        this.session.commit();
    }

    public void registerMeasure(Long id) {
        AsyncMeasuresDao dao = new AsyncMeasuresDao(this.session);
        this.registerMeasure(dao.getAsyncMeasure(id), dao);
    }

    private List<Integer> getMetricIds(List<AsyncMeasureSnapshot> list) {
        ArrayList<Integer> ids = new ArrayList<Integer>();
        for (AsyncMeasureSnapshot ams : list) {
            ids.add(ams.getMetricId());
        }
        return ids;
    }

    private Collection<AsyncMeasureSnapshot> purge(List<AsyncMeasureSnapshot> list) {
        LinkedHashMap<Integer, AsyncMeasureSnapshot> measuresById = new LinkedHashMap<Integer, AsyncMeasureSnapshot>();
        for (AsyncMeasureSnapshot currentAsyncMeasureSnapshot : list) {
            AsyncMeasureSnapshot asyncMeasureSnapshotFromMap = (AsyncMeasureSnapshot)measuresById.get(currentAsyncMeasureSnapshot.getMetricId());
            if (asyncMeasureSnapshotFromMap != null) {
                if (!asyncMeasureSnapshotFromMap.getMeasureDate().before(currentAsyncMeasureSnapshot.getMeasureDate())) continue;
                measuresById.put(currentAsyncMeasureSnapshot.getMetricId(), currentAsyncMeasureSnapshot);
                continue;
            }
            measuresById.put(currentAsyncMeasureSnapshot.getMetricId(), currentAsyncMeasureSnapshot);
        }
        return measuresById.values();
    }

    public void deleteMeasure(Long id) {
        AsyncMeasuresDao dao = new AsyncMeasuresDao(this.session);
        MeasureModel measure = dao.getAsyncMeasure(id);
        AsyncMeasureSnapshot pastAsyncMeasureSnapshot = dao.getLastAsyncMeasureSnapshot(measure.getProjectId(), measure.getMetricId(), measure.getMeasureDate());
        dao.deleteAsyncMeasure(measure);
        if (pastAsyncMeasureSnapshot != null) {
            MeasureModel pastAsyncMeasure = dao.getAsyncMeasure(pastAsyncMeasureSnapshot.getMeasureId());
            dao.deleteAsyncMeasureSnapshots(pastAsyncMeasureSnapshot.getMeasureId());
            this.registerMeasure(pastAsyncMeasure, dao);
        }
        this.session.commit();
    }

    private void registerMeasure(MeasureModel measure, AsyncMeasuresDao dao) {
        AsyncMeasureSnapshot nextAsyncMeasureSnapshot = dao.getNextAsyncMeasureSnapshot(measure.getProjectId(), measure.getMetricId(), measure.getMeasureDate());
        Date dateNextAsyncMeasure = nextAsyncMeasureSnapshot != null ? nextAsyncMeasureSnapshot.getMeasureDate() : null;
        List<AsyncMeasureSnapshot> nextAsyncMeasureSnapshots = dao.getNextAsyncMeasureSnapshotsUntilDate(measure, dateNextAsyncMeasure);
        if (!nextAsyncMeasureSnapshots.isEmpty()) {
            for (AsyncMeasureSnapshot asyncMeasureSnapshot : nextAsyncMeasureSnapshots) {
                dao.createAsyncMeasureSnapshot(measure.getId(), asyncMeasureSnapshot.getSnapshotId(), measure.getMeasureDate(), asyncMeasureSnapshot.getSnapshotDate(), measure.getMetricId(), measure.getProjectId());
                dao.removeSnapshotFromAsyncMeasureSnapshot(asyncMeasureSnapshot);
            }
        } else {
            List<Snapshot> nextSnapshotsUntilDate = dao.getNextSnapshotsUntilDate(measure, dateNextAsyncMeasure);
            if (!nextSnapshotsUntilDate.isEmpty()) {
                for (Snapshot nextSnapshot : nextSnapshotsUntilDate) {
                    dao.createAsyncMeasureSnapshot(measure.getId(), nextSnapshot.getId(), measure.getMeasureDate(), nextSnapshot.getCreatedAt(), measure.getMetricId(), measure.getProjectId());
                }
            } else {
                dao.createAsyncMeasureSnapshot(measure.getId(), null, measure.getMeasureDate(), null, measure.getMetricId(), measure.getProjectId());
            }
        }
    }
}

