/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.jpa.dialect;

import org.apache.commons.lang.StringUtils;
import org.hibernate.dialect.DerbyDialect;
import org.hibernate.id.IdentityGenerator;
import org.sonar.jpa.dialect.Dialect;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Derby
implements Dialect {
    @Override
    public String getId() {
        return "derby";
    }

    @Override
    public String getActiveRecordDialectCode() {
        return "derby";
    }

    @Override
    public Class<? extends org.hibernate.dialect.Dialect> getHibernateDialectClass() {
        return DerbyWithDecimalDialect.class;
    }

    @Override
    public boolean matchesJdbcURL(String jdbcConnectionURL) {
        return StringUtils.startsWithIgnoreCase((String)jdbcConnectionURL, (String)"jdbc:derby:");
    }

    public static class DerbyWithDecimalDialect
    extends DerbyDialect {
        public DerbyWithDecimalDialect() {
            this.registerColumnType(8, "decimal");
            this.registerColumnType(12, 0xFFFFFF, "clob");
            this.registerColumnType(-3, "blob");
            this.registerColumnType(-5, "integer");
        }

        public Class getNativeIdentifierGeneratorClass() {
            return IdentityGenerator.class;
        }
    }
}

