/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.graph;

import org.sonar.graph.Dsm;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DsmTopologicalSorter<V> {
    private final Dsm<V> dsm;
    private int leftOrderedIndex;
    private int rightOrderedIndex;

    private DsmTopologicalSorter(Dsm<V> dsm) {
        this.dsm = dsm;
        this.leftOrderedIndex = 0;
        this.rightOrderedIndex = dsm.getDimension() - 1;
    }

    public static <V> void sort(Dsm<V> dsm) {
        boolean isCyclicGraph;
        DsmTopologicalSorter<V> partitionner = new DsmTopologicalSorter<V>(dsm);
        boolean dsmCanBeSorted = true;
        while (dsmCanBeSorted) {
            boolean dsmCanBeSortedOnLeft = super.pushToLeftVerticesWithoutIncomingEdges();
            boolean dsmCanBeSortedOnRight = super.pushToRightVerticesWithoutOutgointEdges();
            dsmCanBeSorted = dsmCanBeSortedOnLeft || dsmCanBeSortedOnRight;
        }
        boolean bl = isCyclicGraph = partitionner.leftOrderedIndex < partitionner.rightOrderedIndex;
        if (isCyclicGraph) {
            throw new IllegalStateException("Can't sort a cyclic graph.");
        }
    }

    private boolean pushToLeftVerticesWithoutIncomingEdges() {
        boolean permutationsDone = false;
        for (int i = this.leftOrderedIndex; i <= this.rightOrderedIndex; ++i) {
            if (this.dsm.getNumberOfIncomingEdges(i, this.leftOrderedIndex, this.rightOrderedIndex) != 0) continue;
            this.dsm.permute(i, this.leftOrderedIndex);
            ++this.leftOrderedIndex;
            permutationsDone = true;
        }
        return permutationsDone;
    }

    private boolean pushToRightVerticesWithoutOutgointEdges() {
        boolean permutationsDone = false;
        for (int i = this.leftOrderedIndex; i <= this.rightOrderedIndex; ++i) {
            if (this.dsm.getNumberOfOutgoingEdges(i, this.leftOrderedIndex, this.rightOrderedIndex) != 0) continue;
            this.dsm.permute(i, this.rightOrderedIndex);
            --this.rightOrderedIndex;
            permutationsDone = true;
        }
        return permutationsDone;
    }
}

