/*
 * Decompiled with CFR 0.152.
 */
package org.commonjava.maven.enforcer.rule;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.maven.enforcer.rule.api.EnforcerRule;
import org.apache.maven.enforcer.rule.api.EnforcerRuleException;
import org.apache.maven.enforcer.rule.api.EnforcerRuleHelper;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Model;
import org.apache.maven.model.ModelBase;
import org.apache.maven.model.Profile;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.component.configurator.expression.ExpressionEvaluationException;

public class EnforceManagedDepsRule
implements EnforcerRule {
    private boolean checkProfiles = true;
    private boolean failOnViolation = true;
    private String[] regexIgnored = null;

    public void execute(EnforcerRuleHelper helper) throws EnforcerRuleException {
        Log log = helper.getLog();
        try {
            String message;
            MavenProject project = (MavenProject)helper.evaluate("${project}");
            Model model = project.getOriginalModel();
            HashSet<Dependency> failed = new HashSet<Dependency>();
            log.debug((CharSequence)"Checking model...");
            this.check((ModelBase)model, failed);
            if (this.checkProfiles) {
                log.debug((CharSequence)"Checking profiles...");
                List profiles = project.getModel().getProfiles();
                if (profiles != null && !profiles.isEmpty()) {
                    for (Profile profile : profiles) {
                        this.check((ModelBase)profile, failed);
                    }
                }
            }
            if ((message = this.buildFailureMessage(failed)) != null) {
                if (this.failOnViolation) {
                    throw new EnforcerRuleException(message);
                }
                log.warn((CharSequence)message);
            }
        }
        catch (ExpressionEvaluationException e) {
            throw new EnforcerRuleException("Unable to lookup an expression " + e.getLocalizedMessage(), (Exception)((Object)e));
        }
    }

    private String buildFailureMessage(Set<Dependency> failed) {
        if (failed == null || failed.isEmpty()) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        sb.append("The following ").append(failed.size()).append(" dependencies are NOT using a managed version:\n");
        for (Dependency d : failed) {
            sb.append("\n  - ").append(d.getManagementKey());
        }
        return sb.toString();
    }

    private void check(ModelBase src, Set<Dependency> failed) {
        List dependencies = src.getDependencies();
        if (dependencies != null && !dependencies.isEmpty()) {
            for (Dependency dependency : dependencies) {
                if (this.checkRegex(dependency) || dependency.getVersion() == null) continue;
                failed.add(dependency);
            }
        }
    }

    private boolean checkRegex(Dependency dependency) {
        boolean result = false;
        if (this.regexIgnored != null) {
            for (String r : this.regexIgnored) {
                Pattern p = Pattern.compile(r);
                if (!p.matcher(dependency.getGroupId()).find() && !p.matcher(dependency.getArtifactId()).find()) continue;
                result = true;
                break;
            }
        }
        return result;
    }

    public String getCacheId() {
        return "not-cached";
    }

    public boolean isCacheable() {
        return false;
    }

    public boolean isResultValid(EnforcerRule rule) {
        return false;
    }

    public boolean isCheckProfiles() {
        return this.checkProfiles;
    }

    public void setCheckProfiles(boolean checkProfiles) {
        this.checkProfiles = checkProfiles;
    }

    public boolean isFailOnViolation() {
        return this.failOnViolation;
    }

    public void setFailOnViolation(boolean failOnViolation) {
        this.failOnViolation = failOnViolation;
    }

    public void setRegexIgnored(String[] regexIgnored) {
        this.regexIgnored = regexIgnored;
    }
}

