/*
 * Decompiled with CFR 0.152.
 */
package org.commonjava.maven.plugins.execroot;

import java.io.File;
import java.io.PrintWriter;
import java.io.StringWriter;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;

public abstract class AbstractDirectoryGoal
extends AbstractMojo {
    protected String property;
    protected MavenProject currentProject;
    protected MavenSession session;
    protected boolean quiet;
    protected boolean systemProperty;

    protected AbstractDirectoryGoal() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void execute() throws MojoExecutionException, MojoFailureException {
        String existingValue;
        File execRoot;
        MavenSession mavenSession = this.session;
        synchronized (mavenSession) {
            String key = this.getContextKey();
            execRoot = (File)this.getPluginContext().get(key);
            if (execRoot == null) {
                execRoot = this.findDirectory();
                this.getPluginContext().put(key, execRoot);
            }
        }
        if (!this.quiet) {
            this.getLog().info((CharSequence)(this.getLogLabel() + " set to: " + execRoot));
        }
        this.currentProject.getProperties().setProperty(this.property, execRoot.getAbsolutePath());
        if (this.systemProperty && (existingValue = System.getProperty(this.property)) == null) {
            System.setProperty(this.property, execRoot.getAbsolutePath());
        }
        if (this.getLog().isDebugEnabled()) {
            StringWriter str = new StringWriter();
            this.currentProject.getProperties().list(new PrintWriter(str));
            this.getLog().debug((CharSequence)("After setting property '" + this.property + "', project properties are:\n\n" + str));
        }
    }

    protected abstract String getLogLabel();

    protected abstract File findDirectory() throws MojoExecutionException;

    protected abstract String getContextKey();
}

