/*
 * Decompiled with CFR 0.152.
 */
package org.commonjava.maven.plugins.execroot;

import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;

public class ProjectRef {
    private String groupId;
    private String artifactId;

    public String getGroupId() {
        return this.groupId;
    }

    public void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    public void setArtifactId(String artifactId) {
        this.artifactId = artifactId;
    }

    public void validate() throws MojoExecutionException {
        if (this.empty(this.groupId)) {
            throw new MojoExecutionException("Project references must contain groupId AND artifactId.");
        }
        if (this.empty(this.artifactId)) {
            throw new MojoExecutionException("Project references must contain groupId AND artifactId.");
        }
    }

    private boolean empty(String str) {
        return str == null || str.trim().length() == 0;
    }

    public boolean matches(MavenProject project) {
        return project.getGroupId().equals(this.groupId) && project.getArtifactId().equals(this.artifactId);
    }

    public String toString() {
        return this.groupId + ":" + this.artifactId;
    }
}

