/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.server;

import java.io.IOException;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.websocket.api.UpgradeResponse;

public class ServletWebSocketResponse
extends UpgradeResponse {
    private HttpServletResponse resp;

    public ServletWebSocketResponse(HttpServletResponse resp) {
        this.resp = resp;
    }

    public void addHeader(String name, String value) {
        this.resp.addHeader(name, value);
    }

    public int getStatusCode() {
        return this.resp.getStatus();
    }

    public String getStatusReason() {
        throw new UnsupportedOperationException("Server cannot get Status Reason Message");
    }

    public boolean isCommitted() {
        return this.resp.isCommitted();
    }

    public void sendError(int statusCode, String message) throws IOException {
        this.setSuccess(false);
        this.resp.sendError(statusCode, message);
    }

    public void sendForbidden(String message) throws IOException {
        this.setSuccess(false);
        this.resp.sendError(403, message);
    }

    public void setHeader(String name, String value) {
        this.resp.setHeader(name, value);
    }

    public void setStatus(int status) {
        this.resp.setStatus(status);
    }
}

