/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.merge;

import java.util.List;
import org.eclipse.jgit.lib.PersonIdent;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.util.GitDateFormatter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SquashMessageFormatter {
    private GitDateFormatter dateFormatter = new GitDateFormatter(GitDateFormatter.Format.DEFAULT);

    public String format(List<RevCommit> squashedCommits, Ref target) {
        StringBuilder sb = new StringBuilder();
        sb.append("Squashed commit of the following:\n");
        for (RevCommit c : squashedCommits) {
            sb.append("\ncommit ");
            sb.append(c.getName());
            sb.append("\n");
            sb.append(this.toString(c.getAuthorIdent()));
            sb.append("\n\t");
            sb.append(c.getShortMessage());
            sb.append("\n");
        }
        return sb.toString();
    }

    private String toString(PersonIdent author) {
        StringBuilder a = new StringBuilder();
        a.append("Author: ");
        a.append(author.getName());
        a.append(" <");
        a.append(author.getEmailAddress());
        a.append(">\n");
        a.append("Date:   ");
        a.append(this.dateFormatter.formatDate(author));
        a.append("\n");
        return a.toString();
    }
}

