/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.script.mustache;

import java.io.IOException;
import java.util.Map;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.CompositeIndicesRequest;
import org.elasticsearch.action.ValidateActions;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Streamable;
import org.elasticsearch.script.ScriptType;

public class SearchTemplateRequest
extends ActionRequest
implements CompositeIndicesRequest {
    private SearchRequest request;
    private boolean simulate = false;
    private boolean explain = false;
    private boolean profile = false;
    private ScriptType scriptType;
    private String script;
    private Map<String, Object> scriptParams;

    public SearchTemplateRequest() {
    }

    public SearchTemplateRequest(SearchRequest searchRequest) {
        this.request = searchRequest;
    }

    public void setRequest(SearchRequest request) {
        this.request = request;
    }

    public SearchRequest getRequest() {
        return this.request;
    }

    public boolean isSimulate() {
        return this.simulate;
    }

    public void setSimulate(boolean simulate) {
        this.simulate = simulate;
    }

    public boolean isExplain() {
        return this.explain;
    }

    public void setExplain(boolean explain) {
        this.explain = explain;
    }

    public boolean isProfile() {
        return this.profile;
    }

    public void setProfile(boolean profile) {
        this.profile = profile;
    }

    public ScriptType getScriptType() {
        return this.scriptType;
    }

    public void setScriptType(ScriptType scriptType) {
        this.scriptType = scriptType;
    }

    public String getScript() {
        return this.script;
    }

    public void setScript(String script) {
        this.script = script;
    }

    public Map<String, Object> getScriptParams() {
        return this.scriptParams;
    }

    public void setScriptParams(Map<String, Object> scriptParams) {
        this.scriptParams = scriptParams;
    }

    public ActionRequestValidationException validate() {
        ActionRequestValidationException validationException = null;
        if (this.script == null || this.script.isEmpty()) {
            validationException = ValidateActions.addValidationError((String)"template is missing", validationException);
        }
        if (this.scriptType == null) {
            validationException = ValidateActions.addValidationError((String)"template's script type is missing", (ActionRequestValidationException)validationException);
        }
        if (!this.simulate) {
            if (this.request == null) {
                validationException = ValidateActions.addValidationError((String)"search request is missing", (ActionRequestValidationException)validationException);
            } else {
                ActionRequestValidationException ex = this.request.validate();
                if (ex != null) {
                    if (validationException == null) {
                        validationException = new ActionRequestValidationException();
                    }
                    validationException.addValidationErrors((Iterable)ex.validationErrors());
                }
            }
        }
        return validationException;
    }

    public void readFrom(StreamInput in) throws IOException {
        super.readFrom(in);
        this.request = (SearchRequest)in.readOptionalStreamable(SearchRequest::new);
        this.simulate = in.readBoolean();
        this.explain = in.readBoolean();
        this.profile = in.readBoolean();
        this.scriptType = ScriptType.readFrom((StreamInput)in);
        this.script = in.readOptionalString();
        if (in.readBoolean()) {
            this.scriptParams = in.readMap();
        }
    }

    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeOptionalStreamable((Streamable)this.request);
        out.writeBoolean(this.simulate);
        out.writeBoolean(this.explain);
        out.writeBoolean(this.profile);
        this.scriptType.writeTo(out);
        out.writeOptionalString(this.script);
        boolean hasParams = this.scriptParams != null;
        out.writeBoolean(hasParams);
        if (hasParams) {
            out.writeMap(this.scriptParams);
        }
    }
}

