/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.percolator;

import java.io.IOException;
import java.util.ArrayList;
import org.elasticsearch.ResourceNotFoundException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ShardOperationFailedException;
import org.elasticsearch.action.get.GetResponse;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.search.ShardSearchFailure;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.DefaultShardOperationFailedException;
import org.elasticsearch.action.support.HandledTransportAction;
import org.elasticsearch.client.Client;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.common.ParseFieldMatcher;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.text.Text;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.common.xcontent.XContentHelper;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.ConstantScoreQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.index.query.QueryParseContext;
import org.elasticsearch.indices.query.IndicesQueriesRegistry;
import org.elasticsearch.percolator.PercolateQueryBuilder;
import org.elasticsearch.percolator.PercolateRequest;
import org.elasticsearch.percolator.PercolateResponse;
import org.elasticsearch.search.SearchExtRegistry;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.SearchHits;
import org.elasticsearch.search.SearchRequestParsers;
import org.elasticsearch.search.aggregations.AggregatorParsers;
import org.elasticsearch.search.aggregations.InternalAggregations;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;

@Deprecated
public class TransportPercolateAction
extends HandledTransportAction<PercolateRequest, PercolateResponse> {
    private final Client client;
    private final ParseFieldMatcher parseFieldMatcher;
    private final SearchRequestParsers searchRequestParsers;

    @Inject
    public TransportPercolateAction(Settings settings, ThreadPool threadPool, TransportService transportService, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, Client client, SearchRequestParsers searchRequestParsers) {
        super(settings, "indices:data/read/percolate", threadPool, transportService, actionFilters, indexNameExpressionResolver, PercolateRequest::new);
        this.client = client;
        this.searchRequestParsers = searchRequestParsers;
        this.parseFieldMatcher = new ParseFieldMatcher(settings);
    }

    protected void doExecute(final PercolateRequest request, final ActionListener<PercolateResponse> listener) {
        if (request.getRequest() != null) {
            this.client.get(request.getRequest(), (ActionListener)new ActionListener<GetResponse>(){

                public void onResponse(GetResponse getResponse) {
                    if (getResponse.isExists()) {
                        TransportPercolateAction.this.innerDoExecute(request, getResponse.getSourceAsBytesRef(), (ActionListener<PercolateResponse>)listener);
                    } else {
                        this.onFailure((Exception)new ResourceNotFoundException("percolate document [{}/{}/{}] doesn't exist", new Object[]{request.getRequest().index(), request.getRequest().type(), request.getRequest().id()}));
                    }
                }

                public void onFailure(Exception e) {
                    listener.onFailure(e);
                }
            });
        } else {
            this.innerDoExecute(request, null, listener);
        }
    }

    private void innerDoExecute(final PercolateRequest request, BytesReference docSource, final ActionListener<PercolateResponse> listener) {
        SearchRequest searchRequest;
        try {
            searchRequest = TransportPercolateAction.createSearchRequest(request, docSource, this.searchRequestParsers.queryParsers, this.searchRequestParsers.aggParsers, this.searchRequestParsers.searchExtParsers, this.parseFieldMatcher);
        }
        catch (IOException e) {
            listener.onFailure((Exception)e);
            return;
        }
        this.client.search(searchRequest, (ActionListener)new ActionListener<SearchResponse>(){

            public void onResponse(SearchResponse searchResponse) {
                try {
                    listener.onResponse((Object)TransportPercolateAction.createPercolateResponse(searchResponse, request.onlyCount()));
                }
                catch (Exception e) {
                    this.onFailure(e);
                }
            }

            public void onFailure(Exception e) {
                listener.onFailure(e);
            }
        });
    }

    public static SearchRequest createSearchRequest(PercolateRequest percolateRequest, BytesReference documentSource, IndicesQueriesRegistry queryRegistry, AggregatorParsers aggParsers, SearchExtRegistry searchExtRegistry, ParseFieldMatcher parseFieldMatcher) throws IOException {
        Object currentFieldName;
        SearchRequest searchRequest = new SearchRequest();
        if (percolateRequest.indices() != null) {
            searchRequest.indices(percolateRequest.indices());
        }
        searchRequest.indicesOptions(percolateRequest.indicesOptions());
        searchRequest.routing(percolateRequest.routing());
        searchRequest.preference(percolateRequest.preference());
        BytesReference querySource = null;
        XContentBuilder searchSource = XContentFactory.jsonBuilder().startObject();
        if (percolateRequest.source() != null && percolateRequest.source().length() > 0) {
            try (XContentParser parser = XContentHelper.createParser((BytesReference)percolateRequest.source());){
                currentFieldName = null;
                XContentParser.Token token = parser.nextToken();
                if (token != XContentParser.Token.START_OBJECT) {
                    throw new IllegalArgumentException("Unknown token [" + token + "]");
                }
                while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                    if (token == XContentParser.Token.FIELD_NAME) {
                        currentFieldName = parser.currentName();
                        continue;
                    }
                    if (token == XContentParser.Token.START_OBJECT) {
                        XContentBuilder builder;
                        if ("doc".equals(currentFieldName)) {
                            builder = XContentFactory.jsonBuilder();
                            builder.copyCurrentStructure(parser);
                            builder.flush();
                            documentSource = builder.bytes();
                            continue;
                        }
                        if ("query".equals(currentFieldName) || "filter".equals(currentFieldName)) {
                            builder = XContentFactory.jsonBuilder();
                            builder.copyCurrentStructure(parser);
                            builder.flush();
                            querySource = builder.bytes();
                            continue;
                        }
                        if ("sort".equals(currentFieldName)) {
                            searchSource.field("sort");
                            searchSource.copyCurrentStructure(parser);
                            continue;
                        }
                        if ("aggregations".equals(currentFieldName)) {
                            searchSource.field("aggregations");
                            searchSource.copyCurrentStructure(parser);
                            continue;
                        }
                        if ("highlight".equals(currentFieldName)) {
                            searchSource.field("highlight");
                            searchSource.copyCurrentStructure(parser);
                            continue;
                        }
                        throw new IllegalArgumentException("Unknown field [" + (String)currentFieldName + "]");
                    }
                    if (token == XContentParser.Token.START_ARRAY) {
                        if ("sort".equals(currentFieldName)) {
                            searchSource.field("sort");
                            searchSource.copyCurrentStructure(parser);
                            continue;
                        }
                        throw new IllegalArgumentException("Unknown field [" + (String)currentFieldName + "]");
                    }
                    if (token.isValue()) {
                        if ("size".equals(currentFieldName)) {
                            searchSource.field("size", parser.intValue());
                            continue;
                        }
                        if ("sort".equals(currentFieldName)) {
                            searchSource.field("sort", parser.text());
                            continue;
                        }
                        if ("track_scores".equals(currentFieldName) || "trackScores".equals(currentFieldName)) {
                            searchSource.field("track_scores", parser.booleanValue());
                            continue;
                        }
                        throw new IllegalArgumentException("Unknown field [" + (String)currentFieldName + "]");
                    }
                    throw new IllegalArgumentException("Unknown token [" + token + "]");
                }
            }
        }
        if (percolateRequest.onlyCount()) {
            searchSource.field("size", 0);
        }
        PercolateQueryBuilder percolateQueryBuilder = new PercolateQueryBuilder("query", percolateRequest.documentType(), documentSource);
        if (querySource != null) {
            XContentParser parser = XContentHelper.createParser(querySource);
            currentFieldName = null;
            try {
                QueryParseContext queryParseContext = new QueryParseContext(queryRegistry, parser, parseFieldMatcher);
                BoolQueryBuilder boolQueryBuilder = QueryBuilders.boolQuery();
                queryParseContext.parseInnerQueryBuilder().ifPresent(arg_0 -> ((BoolQueryBuilder)boolQueryBuilder).must(arg_0));
                boolQueryBuilder.filter((QueryBuilder)percolateQueryBuilder);
                searchSource.field("query", (ToXContent)boolQueryBuilder);
            }
            catch (Throwable queryParseContext) {
                currentFieldName = queryParseContext;
                throw queryParseContext;
            }
            finally {
                if (parser != null) {
                    if (currentFieldName != null) {
                        try {
                            parser.close();
                        }
                        catch (Throwable queryParseContext) {
                            ((Throwable)currentFieldName).addSuppressed(queryParseContext);
                        }
                    } else {
                        parser.close();
                    }
                }
            }
        } else {
            searchSource.field("query", (ToXContent)new ConstantScoreQueryBuilder((QueryBuilder)percolateQueryBuilder).boost(0.0f));
        }
        searchSource.endObject();
        searchSource.flush();
        BytesReference source = searchSource.bytes();
        SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder();
        try (XContentParser parser = XContentFactory.xContent((XContentType)XContentType.JSON).createParser(source);){
            QueryParseContext context = new QueryParseContext(queryRegistry, parser, parseFieldMatcher);
            searchSourceBuilder.parseXContent(context, aggParsers, null, searchExtRegistry);
            searchRequest.source(searchSourceBuilder);
            SearchRequest searchRequest2 = searchRequest;
            return searchRequest2;
        }
    }

    public static PercolateResponse createPercolateResponse(SearchResponse searchResponse, boolean onlyCount) {
        PercolateResponse.Match[] matches;
        SearchHits hits = searchResponse.getHits();
        if (onlyCount) {
            matches = null;
        } else {
            matches = new PercolateResponse.Match[hits.getHits().length];
            for (int i = 0; i < hits.getHits().length; ++i) {
                SearchHit hit = hits.getHits()[i];
                matches[i] = new PercolateResponse.Match(new Text(hit.getIndex()), new Text(hit.getId()), hit.getScore(), hit.getHighlightFields());
            }
        }
        ArrayList<ShardOperationFailedException> shardFailures = new ArrayList<ShardOperationFailedException>(searchResponse.getShardFailures().length);
        for (ShardSearchFailure shardSearchFailure : searchResponse.getShardFailures()) {
            shardFailures.add((ShardOperationFailedException)new DefaultShardOperationFailedException(shardSearchFailure.index(), shardSearchFailure.shardId(), shardSearchFailure.getCause()));
        }
        return new PercolateResponse(searchResponse.getTotalShards(), searchResponse.getSuccessfulShards(), searchResponse.getFailedShards(), shardFailures, matches, hits.getTotalHits(), searchResponse.getTookInMillis(), (InternalAggregations)searchResponse.getAggregations());
    }
}

