/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.rankeval;

import java.io.IOException;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.index.rankeval.RankEvalSpec;

public class RankEvalRequest
extends ActionRequest {
    private RankEvalSpec rankingEvaluation;

    public ActionRequestValidationException validate() {
        ActionRequestValidationException e = null;
        if (this.rankingEvaluation == null) {
            e = new ActionRequestValidationException();
            e.addValidationError("missing ranking evaluation specification");
        }
        return e;
    }

    public RankEvalSpec getRankEvalSpec() {
        return this.rankingEvaluation;
    }

    public void setRankEvalSpec(RankEvalSpec task) {
        this.rankingEvaluation = task;
    }

    public void readFrom(StreamInput in) throws IOException {
        super.readFrom(in);
        this.rankingEvaluation = new RankEvalSpec(in);
    }

    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        this.rankingEvaluation.writeTo(out);
    }
}

