/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.rankeval;

import java.io.IOException;
import java.util.Objects;
import java.util.Optional;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.search.SearchHit;

public class RatedSearchHit
implements Writeable,
ToXContent {
    private final SearchHit searchHit;
    private final Optional<Integer> rating;

    public RatedSearchHit(SearchHit searchHit, Optional<Integer> rating) {
        this.searchHit = searchHit;
        this.rating = rating;
    }

    RatedSearchHit(StreamInput in) throws IOException {
        this(SearchHit.readSearchHit((StreamInput)in), in.readBoolean() ? Optional.of(in.readVInt()) : Optional.empty());
    }

    public void writeTo(StreamOutput out) throws IOException {
        this.searchHit.writeTo(out);
        out.writeBoolean(this.rating.isPresent());
        if (this.rating.isPresent()) {
            out.writeVInt(this.rating.get().intValue());
        }
    }

    public SearchHit getSearchHit() {
        return this.searchHit;
    }

    public Optional<Integer> getRating() {
        return this.rating;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field("hit", (ToXContent)this.searchHit);
        builder.field("rating", (Integer)this.rating.orElse(null));
        builder.endObject();
        return builder;
    }

    public final boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        RatedSearchHit other = (RatedSearchHit)obj;
        return Objects.equals(this.rating, other.rating) && Objects.equals(this.searchHit, other.searchHit);
    }

    public final int hashCode() {
        return Objects.hash(this.rating, this.searchHit);
    }
}

