/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.rankeval;

import java.io.IOException;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.ConstructingObjectParser;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.index.rankeval.EvalQueryQuality;
import org.elasticsearch.index.rankeval.EvaluationMetric;
import org.elasticsearch.index.rankeval.MetricDetails;
import org.elasticsearch.index.rankeval.RatedDocument;
import org.elasticsearch.index.rankeval.RatedSearchHit;
import org.elasticsearch.search.SearchHit;

public class MeanReciprocalRank
implements EvaluationMetric {
    public static final String NAME = "mean_reciprocal_rank";
    private static final int DEFAULT_RATING_THRESHOLD = 1;
    private static final int DEFAULT_K = 10;
    private final int k;
    private final int relevantRatingThreshhold;
    private static final ParseField RELEVANT_RATING_FIELD = new ParseField("relevant_rating_threshold", new String[0]);
    private static final ParseField K_FIELD = new ParseField("k", new String[0]);
    private static final ConstructingObjectParser<MeanReciprocalRank, Void> PARSER = new ConstructingObjectParser("reciprocal_rank", args -> {
        Integer optionalThreshold = (Integer)args[0];
        Integer optionalK = (Integer)args[1];
        return new MeanReciprocalRank(optionalThreshold == null ? 1 : optionalThreshold, optionalK == null ? 10 : optionalK);
    });

    public MeanReciprocalRank() {
        this(1, 10);
    }

    MeanReciprocalRank(StreamInput in) throws IOException {
        this.relevantRatingThreshhold = in.readVInt();
        this.k = in.readVInt();
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeVInt(this.relevantRatingThreshhold);
        out.writeVInt(this.k);
    }

    public MeanReciprocalRank(int relevantRatingThreshold, int k) {
        if (relevantRatingThreshold < 0) {
            throw new IllegalArgumentException("Relevant rating threshold for precision must be positive integer.");
        }
        if (k <= 0) {
            throw new IllegalArgumentException("Window size k must be positive.");
        }
        this.k = k;
        this.relevantRatingThreshhold = relevantRatingThreshold;
    }

    int getK() {
        return this.k;
    }

    @Override
    public Optional<Integer> forcedSearchSize() {
        return Optional.of(this.k);
    }

    public String getWriteableName() {
        return NAME;
    }

    public int getRelevantRatingThreshold() {
        return this.relevantRatingThreshhold;
    }

    @Override
    public EvalQueryQuality evaluate(String taskId, SearchHit[] hits, List<RatedDocument> ratedDocs) {
        List<RatedSearchHit> ratedHits = EvaluationMetric.joinHitsWithRatings(hits, ratedDocs);
        int firstRelevant = -1;
        int rank = 1;
        for (RatedSearchHit hit : ratedHits) {
            Optional<Integer> rating = hit.getRating();
            if (rating.isPresent() && rating.get() >= this.relevantRatingThreshhold) {
                firstRelevant = rank;
                break;
            }
            ++rank;
        }
        double reciprocalRank = firstRelevant == -1 ? 0.0 : 1.0 / (double)firstRelevant;
        EvalQueryQuality evalQueryQuality = new EvalQueryQuality(taskId, reciprocalRank);
        evalQueryQuality.setMetricDetails(new Breakdown(firstRelevant));
        evalQueryQuality.addHitsAndRatings(ratedHits);
        return evalQueryQuality;
    }

    public static MeanReciprocalRank fromXContent(XContentParser parser) {
        return (MeanReciprocalRank)PARSER.apply(parser, null);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.startObject(NAME);
        builder.field(RELEVANT_RATING_FIELD.getPreferredName(), this.relevantRatingThreshhold);
        builder.field(K_FIELD.getPreferredName(), this.k);
        builder.endObject();
        builder.endObject();
        return builder;
    }

    public final boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        MeanReciprocalRank other = (MeanReciprocalRank)obj;
        return Objects.equals(this.relevantRatingThreshhold, other.relevantRatingThreshhold) && Objects.equals(this.k, other.k);
    }

    public final int hashCode() {
        return Objects.hash(this.relevantRatingThreshhold, this.k);
    }

    static {
        PARSER.declareInt(ConstructingObjectParser.optionalConstructorArg(), RELEVANT_RATING_FIELD);
        PARSER.declareInt(ConstructingObjectParser.optionalConstructorArg(), K_FIELD);
    }

    static class Breakdown
    implements MetricDetails {
        private final int firstRelevantRank;

        Breakdown(int firstRelevantRank) {
            this.firstRelevantRank = firstRelevantRank;
        }

        Breakdown(StreamInput in) throws IOException {
            this.firstRelevantRank = in.readVInt();
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.field("first_relevant", this.firstRelevantRank);
            return builder;
        }

        public void writeTo(StreamOutput out) throws IOException {
            out.writeVInt(this.firstRelevantRank);
        }

        public String getWriteableName() {
            return MeanReciprocalRank.NAME;
        }

        int getFirstRelevantRank() {
            return this.firstRelevantRank;
        }

        public final boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            Breakdown other = (Breakdown)obj;
            return Objects.equals(this.firstRelevantRank, other.firstRelevantRank);
        }

        public final int hashCode() {
            return Objects.hash(this.firstRelevantRank);
        }
    }
}

