/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.transport.nio;

import java.io.IOException;
import java.nio.channels.SocketChannel;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.nio.NioSocketChannel;
import org.elasticsearch.transport.OutboundHandler;
import org.elasticsearch.transport.TcpChannel;

public class NioTcpChannel
extends NioSocketChannel
implements TcpChannel {
    private final boolean isServer;
    private final String profile;
    private final TcpChannel.ChannelStats stats = new TcpChannel.ChannelStats();

    public NioTcpChannel(boolean isServer, String profile, SocketChannel socketChannel) {
        super(socketChannel);
        this.isServer = isServer;
        this.profile = profile;
    }

    public void sendMessage(OutboundHandler.SendContext sendContext) {
        BytesReference message;
        try {
            message = sendContext.get();
        }
        catch (IOException e) {
            sendContext.onFailure((Exception)e);
            return;
        }
        this.getContext().sendMessage((Object)BytesReference.toByteBuffers((BytesReference)message), ActionListener.toBiConsumer((ActionListener)sendContext));
    }

    public boolean isServerChannel() {
        return this.isServer;
    }

    public String getProfile() {
        return this.profile;
    }

    public void addCloseListener(ActionListener<Void> listener) {
        this.addCloseListener(ActionListener.toBiConsumer(listener));
    }

    public void addConnectListener(ActionListener<Void> listener) {
        this.addConnectListener(ActionListener.toBiConsumer(listener));
    }

    public TcpChannel.ChannelStats getChannelStats() {
        return this.stats;
    }

    public void close() {
        this.getContext().closeChannel();
    }

    public String toString() {
        return "TcpNioSocketChannel{localAddress=" + this.getLocalAddress() + ", remoteAddress=" + this.getRemoteAddress() + '}';
    }
}

