/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core;

import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ExecutionException;
import org.elasticsearch.action.Action;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.support.PlainActionFuture;
import org.elasticsearch.client.Client;
import org.elasticsearch.client.ElasticsearchClient;
import org.elasticsearch.common.settings.SecureString;
import org.elasticsearch.license.LicensingClient;
import org.elasticsearch.protocol.xpack.XPackInfoRequest;
import org.elasticsearch.protocol.xpack.XPackInfoResponse;
import org.elasticsearch.xpack.core.action.TransportFreezeIndexAction;
import org.elasticsearch.xpack.core.action.XPackInfoAction;
import org.elasticsearch.xpack.core.action.XPackInfoRequestBuilder;
import org.elasticsearch.xpack.core.ccr.client.CcrClient;
import org.elasticsearch.xpack.core.indexlifecycle.client.ILMClient;
import org.elasticsearch.xpack.core.ml.client.MachineLearningClient;
import org.elasticsearch.xpack.core.monitoring.client.MonitoringClient;
import org.elasticsearch.xpack.core.security.authc.support.UsernamePasswordToken;
import org.elasticsearch.xpack.core.security.client.SecurityClient;
import org.elasticsearch.xpack.core.watcher.client.WatcherClient;

public class XPackClient {
    private final Client client;
    private final CcrClient ccrClient;
    private final LicensingClient licensingClient;
    private final MonitoringClient monitoringClient;
    private final SecurityClient securityClient;
    private final WatcherClient watcherClient;
    private final MachineLearningClient machineLearning;
    private final ILMClient ilmClient;

    public XPackClient(Client client) {
        this.client = Objects.requireNonNull(client, "client");
        this.ccrClient = new CcrClient((ElasticsearchClient)client);
        this.licensingClient = new LicensingClient((ElasticsearchClient)client);
        this.monitoringClient = new MonitoringClient(client);
        this.securityClient = new SecurityClient((ElasticsearchClient)client);
        this.watcherClient = new WatcherClient(client);
        this.machineLearning = new MachineLearningClient((ElasticsearchClient)client);
        this.ilmClient = new ILMClient((ElasticsearchClient)client);
    }

    public Client es() {
        return this.client;
    }

    public CcrClient ccr() {
        return this.ccrClient;
    }

    public LicensingClient licensing() {
        return this.licensingClient;
    }

    public MonitoringClient monitoring() {
        return this.monitoringClient;
    }

    public SecurityClient security() {
        return this.securityClient;
    }

    public WatcherClient watcher() {
        return this.watcherClient;
    }

    public MachineLearningClient machineLearning() {
        return this.machineLearning;
    }

    public ILMClient ilmClient() {
        return this.ilmClient;
    }

    public XPackClient withHeaders(Map<String, String> headers) {
        return new XPackClient(this.client.filterWithHeader(headers));
    }

    public XPackClient withAuth(String username, char[] passwd) {
        return this.withHeaders(Collections.singletonMap("Authorization", UsernamePasswordToken.basicAuthHeaderValue(username, new SecureString(passwd))));
    }

    public XPackInfoRequestBuilder prepareInfo() {
        return new XPackInfoRequestBuilder((ElasticsearchClient)this.client);
    }

    public void info(XPackInfoRequest request, ActionListener<XPackInfoResponse> listener) {
        this.client.execute((Action)XPackInfoAction.INSTANCE, (ActionRequest)request, listener);
    }

    public void freeze(TransportFreezeIndexAction.FreezeRequest request, ActionListener<TransportFreezeIndexAction.FreezeResponse> listener) {
        this.client.execute((Action)TransportFreezeIndexAction.FreezeIndexAction.INSTANCE, (ActionRequest)request, listener);
    }

    public TransportFreezeIndexAction.FreezeResponse freeze(TransportFreezeIndexAction.FreezeRequest request) throws ExecutionException, InterruptedException {
        PlainActionFuture future = new PlainActionFuture();
        this.freeze(request, (ActionListener<TransportFreezeIndexAction.FreezeResponse>)future);
        return (TransportFreezeIndexAction.FreezeResponse)((Object)future.get());
    }
}

