/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ml.action;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.action.Action;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionRequestBuilder;
import org.elasticsearch.action.support.tasks.BaseTasksResponse;
import org.elasticsearch.client.ElasticsearchClient;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.xcontent.StatusToXContentObject;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.xpack.core.ml.action.JobTaskRequest;
import org.elasticsearch.xpack.core.ml.job.config.DataDescription;
import org.elasticsearch.xpack.core.ml.job.process.autodetect.state.DataCounts;

public class PostDataAction
extends Action<Request, Response, RequestBuilder> {
    public static final PostDataAction INSTANCE = new PostDataAction();
    public static final String NAME = "cluster:admin/xpack/ml/job/data/post";

    private PostDataAction() {
        super(NAME);
    }

    public RequestBuilder newRequestBuilder(ElasticsearchClient client) {
        return new RequestBuilder(client, this);
    }

    public Response newResponse() {
        return new Response();
    }

    public static class Request
    extends JobTaskRequest<Request> {
        public static final ParseField RESET_START = new ParseField("reset_start", new String[0]);
        public static final ParseField RESET_END = new ParseField("reset_end", new String[0]);
        private String resetStart = "";
        private String resetEnd = "";
        private DataDescription dataDescription;
        private XContentType xContentType;
        private BytesReference content;

        public Request() {
        }

        public Request(StreamInput in) throws IOException {
            super(in);
            this.resetStart = in.readOptionalString();
            this.resetEnd = in.readOptionalString();
            this.dataDescription = (DataDescription)in.readOptionalWriteable(DataDescription::new);
            this.content = in.readBytesReference();
            if (in.readBoolean()) {
                this.xContentType = (XContentType)in.readEnum(XContentType.class);
            }
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeOptionalString(this.resetStart);
            out.writeOptionalString(this.resetEnd);
            out.writeOptionalWriteable((Writeable)this.dataDescription);
            out.writeBytesReference(this.content);
            boolean hasXContentType = this.xContentType != null;
            out.writeBoolean(hasXContentType);
            if (hasXContentType) {
                out.writeEnum((Enum)this.xContentType);
            }
        }

        public Request(String jobId) {
            super(jobId);
        }

        public String getResetStart() {
            return this.resetStart;
        }

        public void setResetStart(String resetStart) {
            this.resetStart = resetStart;
        }

        public String getResetEnd() {
            return this.resetEnd;
        }

        public void setResetEnd(String resetEnd) {
            this.resetEnd = resetEnd;
        }

        public DataDescription getDataDescription() {
            return this.dataDescription;
        }

        public void setDataDescription(DataDescription dataDescription) {
            this.dataDescription = dataDescription;
        }

        public BytesReference getContent() {
            return this.content;
        }

        public XContentType getXContentType() {
            return this.xContentType;
        }

        public void setContent(BytesReference content, XContentType xContentType) {
            this.content = content;
            this.xContentType = xContentType;
        }

        public int hashCode() {
            return Objects.hash(this.jobId, this.resetStart, this.resetEnd, this.dataDescription, this.xContentType);
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (((Object)((Object)this)).getClass() != obj.getClass()) {
                return false;
            }
            Request other = (Request)((Object)obj);
            return Objects.equals(this.jobId, other.jobId) && Objects.equals(this.resetStart, other.resetStart) && Objects.equals(this.resetEnd, other.resetEnd) && Objects.equals(this.dataDescription, other.dataDescription) && Objects.equals(this.xContentType, other.xContentType);
        }
    }

    public static class Response
    extends BaseTasksResponse
    implements StatusToXContentObject,
    Writeable {
        private DataCounts dataCounts;

        public Response(String jobId) {
            super(null, null);
            this.dataCounts = new DataCounts(jobId);
        }

        public Response() {
            super(null, null);
        }

        public Response(DataCounts counts) {
            super(null, null);
            this.dataCounts = counts;
        }

        public DataCounts getDataCounts() {
            return this.dataCounts;
        }

        public void readFrom(StreamInput in) throws IOException {
            super.readFrom(in);
            this.dataCounts = new DataCounts(in);
        }

        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            this.dataCounts.writeTo(out);
        }

        public RestStatus status() {
            return RestStatus.ACCEPTED;
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            this.dataCounts.doXContentBody(builder, params);
            builder.endObject();
            return builder;
        }

        public int hashCode() {
            return Objects.hashCode(this.dataCounts);
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (((Object)((Object)this)).getClass() != obj.getClass()) {
                return false;
            }
            Response other = (Response)((Object)obj);
            return Objects.equals(this.dataCounts, other.dataCounts);
        }
    }

    static class RequestBuilder
    extends ActionRequestBuilder<Request, Response, RequestBuilder> {
        RequestBuilder(ElasticsearchClient client, PostDataAction action) {
            super(client, (Action)action, (ActionRequest)new Request());
        }
    }
}

