/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.security.authz;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public final class ResolvedIndices {
    private final List<String> local;
    private final List<String> remote;

    public ResolvedIndices(List<String> local, List<String> remote) {
        this.local = Collections.unmodifiableList(local);
        this.remote = Collections.unmodifiableList(remote);
    }

    public List<String> getLocal() {
        return this.local;
    }

    public List<String> getRemote() {
        return this.remote;
    }

    public boolean isEmpty() {
        return this.local.isEmpty() && this.remote.isEmpty();
    }

    public boolean isNoIndicesPlaceholder() {
        return this.remote.isEmpty() && this.local.size() == 1 && this.local.contains("-*");
    }

    public String[] toArray() {
        String[] array = new String[this.local.size() + this.remote.size()];
        int i = 0;
        for (String index : this.local) {
            array[i++] = index;
        }
        for (String index : this.remote) {
            array[i++] = index;
        }
        return array;
    }

    public static class Builder {
        private final List<String> local = new ArrayList<String>();
        private final List<String> remote = new ArrayList<String>();

        public void addLocal(String index) {
            this.local.add(index);
        }

        public void addLocal(String[] indices) {
            this.local.addAll(Arrays.asList(indices));
        }

        public void addLocal(List<String> indices) {
            this.local.addAll(indices);
        }

        public void addRemote(List<String> indices) {
            this.remote.addAll(indices);
        }

        public boolean isEmpty() {
            return this.local.isEmpty() && this.remote.isEmpty();
        }

        public ResolvedIndices build() {
            return new ResolvedIndices(this.local, this.remote);
        }
    }
}

