/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.jar.JarInputStream;
import java.util.jar.Manifest;
import org.elasticsearch.common.SuppressForbidden;
import org.elasticsearch.common.io.PathUtils;

public class XPackBuild {
    public static final XPackBuild CURRENT;
    private String shortHash;
    private String date;

    @SuppressForbidden(reason="looks up path of xpack.jar directly")
    static Path getElasticsearchCodebase() {
        URL url = XPackBuild.class.getProtectionDomain().getCodeSource().getLocation();
        try {
            return PathUtils.get((URI)url.toURI());
        }
        catch (URISyntaxException bogus) {
            throw new RuntimeException(bogus);
        }
    }

    XPackBuild(String shortHash, String date) {
        this.shortHash = shortHash;
        this.date = date;
    }

    public String shortHash() {
        return this.shortHash;
    }

    public String date() {
        return this.date;
    }

    static {
        String date;
        String shortHash;
        block8: {
            Path path = XPackBuild.getElasticsearchCodebase();
            if (path.toString().endsWith(".jar")) {
                try (JarInputStream jar = new JarInputStream(Files.newInputStream(path, new OpenOption[0]));){
                    Manifest manifest = jar.getManifest();
                    shortHash = manifest.getMainAttributes().getValue("Change");
                    date = manifest.getMainAttributes().getValue("Build-Date");
                    break block8;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            shortHash = "Unknown";
            date = "Unknown";
        }
        CURRENT = new XPackBuild(shortHash, date);
    }
}

