/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.action;

import java.util.Set;
import java.util.stream.Collectors;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.HandledTransportAction;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.license.License;
import org.elasticsearch.license.LicenseService;
import org.elasticsearch.protocol.xpack.XPackInfoRequest;
import org.elasticsearch.protocol.xpack.XPackInfoResponse;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.core.XPackBuild;
import org.elasticsearch.xpack.core.XPackFeatureSet;

public class TransportXPackInfoAction
extends HandledTransportAction<XPackInfoRequest, XPackInfoResponse> {
    private final LicenseService licenseService;
    private final Set<XPackFeatureSet> featureSets;

    @Inject
    public TransportXPackInfoAction(TransportService transportService, ActionFilters actionFilters, LicenseService licenseService, Set<XPackFeatureSet> featureSets) {
        super("cluster:monitor/xpack/info", transportService, actionFilters, XPackInfoRequest::new);
        this.licenseService = licenseService;
        this.featureSets = featureSets;
    }

    protected void doExecute(Task task, XPackInfoRequest request, ActionListener<XPackInfoResponse> listener) {
        License license;
        XPackInfoResponse.BuildInfo buildInfo = null;
        if (request.getCategories().contains((Object)XPackInfoRequest.Category.BUILD)) {
            buildInfo = new XPackInfoResponse.BuildInfo(XPackBuild.CURRENT.shortHash(), XPackBuild.CURRENT.date());
        }
        XPackInfoResponse.LicenseInfo licenseInfo = null;
        if (request.getCategories().contains((Object)XPackInfoRequest.Category.LICENSE) && (license = this.licenseService.getLicense()) != null) {
            String type = license.type();
            License.OperationMode mode = license.operationMode();
            if (request.getLicenseVersion() < 5) {
                if (License.LicenseType.ENTERPRISE.getTypeName().equals(type)) {
                    type = License.LicenseType.PLATINUM.getTypeName();
                }
                if (mode == License.OperationMode.ENTERPRISE) {
                    mode = License.OperationMode.PLATINUM;
                }
            }
            licenseInfo = new XPackInfoResponse.LicenseInfo(license.uid(), type, mode.description(), license.status(), license.expiryDate());
        }
        XPackInfoResponse.FeatureSetsInfo featureSetsInfo = null;
        if (request.getCategories().contains((Object)XPackInfoRequest.Category.FEATURES)) {
            Set<XPackInfoResponse.FeatureSetsInfo.FeatureSet> featureSets = this.featureSets.stream().map(fs -> new XPackInfoResponse.FeatureSetsInfo.FeatureSet(fs.name(), fs.available(), fs.enabled(), request.isVerbose() ? fs.nativeCodeInfo() : null)).collect(Collectors.toSet());
            featureSetsInfo = new XPackInfoResponse.FeatureSetsInfo(featureSets);
        }
        listener.onResponse((Object)new XPackInfoResponse(buildInfo, licenseInfo, featureSetsInfo));
    }
}

