/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.common.notifications;

import java.io.IOException;
import java.util.Date;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.index.IndexResponse;
import org.elasticsearch.client.Client;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.xpack.core.ClientHelper;
import org.elasticsearch.xpack.core.common.notifications.AbstractAuditMessage;
import org.elasticsearch.xpack.core.common.notifications.AbstractAuditMessageFactory;
import org.elasticsearch.xpack.core.common.notifications.Level;

public abstract class AbstractAuditor<T extends AbstractAuditMessage> {
    private static final Logger logger = LogManager.getLogger(AbstractAuditor.class);
    private final Client client;
    private final String nodeName;
    private final String auditIndex;
    private final String executionOrigin;
    private final AbstractAuditMessageFactory<T> messageFactory;

    protected AbstractAuditor(Client client, String nodeName, String auditIndex, String executionOrigin, AbstractAuditMessageFactory<T> messageFactory) {
        this.client = Objects.requireNonNull(client);
        this.nodeName = Objects.requireNonNull(nodeName);
        this.auditIndex = auditIndex;
        this.executionOrigin = executionOrigin;
        this.messageFactory = Objects.requireNonNull(messageFactory);
    }

    public void info(String resourceId, String message) {
        this.indexDoc((ToXContent)this.messageFactory.newMessage(resourceId, message, Level.INFO, new Date(), this.nodeName));
    }

    public void warning(String resourceId, String message) {
        this.indexDoc((ToXContent)this.messageFactory.newMessage(resourceId, message, Level.WARNING, new Date(), this.nodeName));
    }

    public void error(String resourceId, String message) {
        this.indexDoc((ToXContent)this.messageFactory.newMessage(resourceId, message, Level.ERROR, new Date(), this.nodeName));
    }

    private void onIndexResponse(IndexResponse response) {
        logger.trace("Successfully wrote audit message");
    }

    private void onIndexFailure(Exception exception) {
        logger.debug("Failed to write audit message", (Throwable)exception);
    }

    private void indexDoc(ToXContent toXContent) {
        IndexRequest indexRequest = new IndexRequest(this.auditIndex);
        indexRequest.source(this.toXContentBuilder(toXContent));
        indexRequest.timeout(TimeValue.timeValueSeconds((long)5L));
        ClientHelper.executeAsyncWithOrigin(this.client.threadPool().getThreadContext(), this.executionOrigin, indexRequest, ActionListener.wrap(this::onIndexResponse, this::onIndexFailure), (arg_0, arg_1) -> ((Client)this.client).index(arg_0, arg_1));
    }

    private XContentBuilder toXContentBuilder(ToXContent toXContent) {
        XContentBuilder xContentBuilder;
        block8: {
            XContentBuilder jsonBuilder = XContentFactory.jsonBuilder();
            try {
                xContentBuilder = toXContent.toXContent(jsonBuilder, ToXContent.EMPTY_PARAMS);
                if (jsonBuilder == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (jsonBuilder != null) {
                        try {
                            jsonBuilder.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            jsonBuilder.close();
        }
        return xContentBuilder;
    }
}

